<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-11-19 19:51:33
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Application
 * @method createOrEditAppByParams(array $params) 创建应用
 * @method getAppDetailByParams(array $params) 获取应用详情
 * @method getAppListByParams(array $params) 获取应用列表(全部)
 * @method getAppListByPageByParams(array $params) 获取应用列表(分页)
 * @method deleteAppByParams(array $params) 下架应用
 */
class Application {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Application";

    /**
     * 创建应用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function createOrEditApp (string $appNo, string $appName, string $appMd5, string $asarDownUrl, string $appIcon, string $themeColor) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createOrEditApp(["appNo" => $appNo, "appName" => $appName, "appMd5" => $appMd5, "asarDownUrl" => $asarDownUrl, "appIcon" => $appIcon, "themeColor" => $themeColor]);
    }

    /**
     * 获取应用详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Application\Dto\ApplicationDto
    */
    public static function getAppDetail (string $appNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAppDetail(["appNo" => $appNo]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Application\Dto\ApplicationDto"
        );
    }

    /**
     * 获取应用列表(全部)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAppList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAppList([]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Application\Dto\ApplicationDto[]"
        );
    }

    /**
     * 获取应用列表(分页)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Application\Dto\ApplicationPageDto
    */
    public static function getAppListByPage () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAppListByPage([]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Application\Dto\ApplicationPageDto"
        );
    }

    /**
     * 下架应用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function deleteApp (string $appNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteApp(["appNo" => $appNo]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}