<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-11-21 17:58:16
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class GiftCardOrder
 * @method getPayTypesByParams(array $params) 礼品卡订单支付类型
 * @method listByParams(array $params) 获取礼品卡订单列表
 * @method createByParams(array $params) 礼品卡订单录入
 * @method detailByParams(array $params) 礼品卡订单详情
 * @method canSaleCardListByParams(array $params) 可售卖礼品卡列表
 * @method detailByNumByParams(array $params) 通过订单号获取礼品卡订单详情
 * @method changePayTypeByParams(array $params) 财务修改支付方式
 */
class GiftCardOrder {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\GiftCardOrder";

    /**
     * 礼品卡订单支付类型
     * @return  mixed
    */
    public static function getPayTypes () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPayTypes();
    }

    /**
     * 获取礼品卡订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }

    /**
     * 礼品卡订单录入
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function create (string $user_name, string $type, string $phone, string $sex, string $pay_type, string $buy_channel = 'headquarters') {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["user_name" => $user_name, "type" => $type, "phone" => $phone, "sex" => $sex, "pay_type" => $pay_type, "buy_channel" => $buy_channel]);
    }

    /**
     * 礼品卡订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 可售卖礼品卡列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function canSaleCardList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->canSaleCardList([]);
    }

    /**
     * 通过订单号获取礼品卡订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detailByNum (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailByNum(["order_no" => $order_no]);
    }

    /**
     * 财务修改支付方式
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function changePayType (int $id, string $pay_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "pay_type" => $pay_type]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}