<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-11-21 18:18:35
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Extend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class MeiTuan
 * @method authByParams(array $params) 业务授权URL拼装
 * @method oauthTokenByParams(array $params) 获取authorization_code并且使用authorization_code换取access_token(即appAuthToken)
 * @method oauthRefreshByParams(array $params) 每天凌晨三点去更新access_token
 * @method sessionByParams(array $params) 查询原北极星有效session
 * @method pageQueryPoiListByParams(array $params) 适用门店查询
 * @method bindMeiTuanStoreByParams(array $params) 海马体门店与美团门店绑定
 * @method meiTuanKhGeneralReserveCancelByParams(array $params) 通用预约-取消同步三方接口
 * @method meiTuanKhGeneralReserveCancelResultByParams(array $params) 通用预约-取消结果同步三方
 * @method meiTuanKhGeneralReserveCreateOrderByParams(array $params) 通用预约-创单同步三方接口
 * @method meiTuanKhGeneralReserveModifyByParams(array $params) 通用预约-用户改约
 * @method meiTuanKhGeneralReserveQueryStockByParams(array $params) 通用预约-查询库存
 * @method meiTuanKhGeneralReserveUserFullFillByParams(array $params) 通用预约-履约状态变更通知商家
 * @method getMeiTuanTokenByParams(array $params) 通用预约-查询token用于预约端核销
 * @method receiptNoticeByParams(array $params) 通用预约-订单信息推送
 */
class MeiTuan {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Extend\\MeiTuan";

    /**
     * 业务授权URL拼装
     * @return  string
    */
    public static function auth (\Mainto\Bridge\Structs\HimoProduct\Admin\MeiTuan\Cmd\AuthCmd $authCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->auth($authCmd);
    }

    /**
     * 获取authorization_code并且使用authorization_code换取access_token(即appAuthToken)
     * @return  array
    */
    public static function oauthToken (\Mainto\Bridge\Structs\HimoProduct\Admin\MeiTuan\Cmd\AuthorizationCodeCmd $authorizationCodeCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->oauthToken($authorizationCodeCmd);
    }

    /**
     * 每天凌晨三点去更新access_token
     * @return  bool
    */
    public static function oauthRefresh () {
        return RpcClass::getClass(self::$serviceName, self::$className)->oauthRefresh();
    }

    /**
     * 查询原北极星有效session
     * @return  array
    */
    public static function session () {
        return RpcClass::getClass(self::$serviceName, self::$className)->session();
    }

    /**
     * 适用门店查询
     * @return  mixed
    */
    public static function pageQueryPoiList (\Mainto\Bridge\Structs\HimoProduct\Admin\MeiTuan\Cmd\PageQueryPoiListCmd $pageQueryPoiListCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pageQueryPoiList($pageQueryPoiListCmd);
    }

    /**
     * 海马体门店与美团门店绑定
     * @return  array
    */
    public static function bindMeiTuanStore (\Mainto\Bridge\Structs\HimoProduct\Admin\MeiTuan\Cmd\BatchBindCmd $batchBindCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindMeiTuanStore($batchBindCmd);
    }

    /**
     * 通用预约-取消同步三方接口
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function meiTuanKhGeneralReserveCancel (int $msgType, int $timestamp, string $sign, int $developerId, int $businessId, string $msgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->meiTuanKhGeneralReserveCancel(["msgType" => $msgType, "timestamp" => $timestamp, "sign" => $sign, "developerId" => $developerId, "businessId" => $businessId, "msgId" => $msgId]);
    }

    /**
     * 通用预约-取消结果同步三方
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function meiTuanKhGeneralReserveCancelResult (int $msgType, int $timestamp, string $sign, int $developerId, int $businessId, string $msgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->meiTuanKhGeneralReserveCancelResult(["msgType" => $msgType, "timestamp" => $timestamp, "sign" => $sign, "developerId" => $developerId, "businessId" => $businessId, "msgId" => $msgId]);
    }

    /**
     * 通用预约-创单同步三方接口
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function meiTuanKhGeneralReserveCreateOrder (int $msgType, int $timestamp, string $sign, int $developerId, int $businessId, string $msgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->meiTuanKhGeneralReserveCreateOrder(["msgType" => $msgType, "timestamp" => $timestamp, "sign" => $sign, "developerId" => $developerId, "businessId" => $businessId, "msgId" => $msgId]);
    }

    /**
     * 通用预约-用户改约
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function meiTuanKhGeneralReserveModify (int $msgType, int $timestamp, string $sign, int $developerId, int $businessId, string $msgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->meiTuanKhGeneralReserveModify(["msgType" => $msgType, "timestamp" => $timestamp, "sign" => $sign, "developerId" => $developerId, "businessId" => $businessId, "msgId" => $msgId]);
    }

    /**
     * 通用预约-查询库存
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function meiTuanKhGeneralReserveQueryStock (int $msgType, int $timestamp, string $sign, int $developerId, int $businessId, string $msgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->meiTuanKhGeneralReserveQueryStock(["msgType" => $msgType, "timestamp" => $timestamp, "sign" => $sign, "developerId" => $developerId, "businessId" => $businessId, "msgId" => $msgId]);
    }

    /**
     * 通用预约-履约状态变更通知商家
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function meiTuanKhGeneralReserveUserFullFill (int $msgType, int $timestamp, string $sign, int $developerId, int $businessId, string $msgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->meiTuanKhGeneralReserveUserFullFill(["msgType" => $msgType, "timestamp" => $timestamp, "sign" => $sign, "developerId" => $developerId, "businessId" => $businessId, "msgId" => $msgId]);
    }

    /**
     * 通用预约-查询token用于预约端核销
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\MeiTuan\Dto\GetMeiTuanTokenDto
    */
    public static function getMeiTuanToken (\Mainto\Bridge\Structs\HimoProduct\Admin\MeiTuan\Cmd\GetMeiTuanTokenCmd $getMeiTuanTokenCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMeiTuanToken($getMeiTuanTokenCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\MeiTuan\Dto\GetMeiTuanTokenDto"
        );
    }

    /**
     * 通用预约-订单信息推送
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function receiptNotice (int $msgType, int $timestamp, string $sign, int $developerId, int $businessId, string $msgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiptNotice(["msgType" => $msgType, "timestamp" => $timestamp, "sign" => $sign, "developerId" => $developerId, "businessId" => $businessId, "msgId" => $msgId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}