<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-11-15 12:11:53
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ProductArea
 * @method areaIdsBindPriceByParams(array $params) 多个价格区绑定价格
 * @method areaIdsUnbindPriceByParams(array $params) 多个价格区解绑价格
 * @method areaBindStoreByParams(array $params) 分区绑定门店(非增量)
 * @method afterAreaBindStoreByParams(array $params) 分区绑定门店后续
 * @method areaAddByParams(array $params) 新增门店分区
 * @method areaAllByParams(array $params) 所有门店分区
 * @method areaUpdateByParams(array $params) 编辑门店分区
 * @method areaDeleteByParams(array $params) 删除门店分区
 * @method updateJxjyGonggePriceByParams(array $params) 更新加修加印价格
 */
class ProductArea {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\ProductArea";

    /**
     * 多个价格区绑定价格
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function areaIdsBindPrice (int $product_id, array $price_area_ids, float $deposit_price = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->areaIdsBindPrice(["product_id" => $product_id, "price_area_ids" => $price_area_ids, "deposit_price" => $deposit_price]);
    }

    /**
     * 多个价格区解绑价格
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function areaIdsUnbindPrice (array $price_area_ids, int $price_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->areaIdsUnbindPrice(["price_area_ids" => $price_area_ids, "price_id" => $price_id]);
    }

    /**
     * 分区绑定门店(非增量)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\Dto\AreaBindStoreDto
    */
    public static function areaBindStore (int $area_id, array $store_ids = [], string $type = 'price') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->areaBindStore(["area_id" => $area_id, "store_ids" => $store_ids, "type" => $type]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\Dto\AreaBindStoreDto"
        );
    }

    /**
     * 分区绑定门店后续
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function afterAreaBindStore (array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterAreaBindStore(["storeIds" => $storeIds]);
    }

    /**
     * 新增门店分区
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\Dto\AreaDto
    */
    public static function areaAdd (string $name, string $module, string $type = 'price') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->areaAdd(["name" => $name, "module" => $module, "type" => $type]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\Dto\AreaDto"
        );
    }

    /**
     * 所有门店分区
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\Dto\AreaAllDto
    */
    public static function areaAll (string $module, string $type = '') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->areaAll(["module" => $module, "type" => $type]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\Dto\AreaAllDto"
        );
    }

    /**
     * 编辑门店分区
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\Dto\AreaDto
    */
    public static function areaUpdate (int $area_id, string $name, string $module, string $type = 'price') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->areaUpdate(["area_id" => $area_id, "name" => $name, "module" => $module, "type" => $type]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\Dto\AreaDto"
        );
    }

    /**
     * 删除门店分区
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function areaDelete (int $area_id, string $type = 'price') {
        return RpcClass::getClass(self::$serviceName, self::$className)->areaDelete(["area_id" => $area_id, "type" => $type]);
    }

    /**
     * 更新加修加印价格
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updateJxjyGonggePrice (\Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\UpdateJxjyGonggePriceParamsJxjyPrice $jxjyPrice) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateJxjyGonggePrice(["jxjyPrice" => $jxjyPrice]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}