<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-11-18 16:11:17
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ProductGift
 * @method getAllProductGiftByParams(array $params) 获取零售赠品列表
 * @method getProductGiftConfigByParams(array $params) 获取赠品配置信息
 * @method getProductGiftRuleByParams(array $params) 获取赠品规则
 * @method addProductGiftRuleByParams(array $params) 编辑多条赠品规则
 * @method deleteProductGiftRuleAndGiftConfigByParams(array $params) 删除多条赠品规则
 * @method executeRuleByParams(array $params) 发放或查询符合规则的赠品
 * @method batchExecuteRuleByParams(array $params) 发放或查询符合规则的赠品
 */
class ProductGift {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\ProductGift";

    /**
     * 获取零售赠品列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAllProductGift (bool $isOnlyShelveUp = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProductGift(["isOnlyShelveUp" => $isOnlyShelveUp]);
    }

    /**
     * 获取赠品配置信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductGiftConfig (bool $include_delete = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductGiftConfig(["include_delete" => $include_delete]);
    }

    /**
     * 获取赠品规则
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductGiftRule () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductGiftRule([]);
    }

    /**
     * 编辑多条赠品规则
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function addProductGiftRule (int $node_id, string $config_name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addProductGiftRule(["node_id" => $node_id, "config_name" => $config_name]);
    }

    /**
     * 删除多条赠品规则
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function deleteProductGiftRuleAndGiftConfig (int $node_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteProductGiftRuleAndGiftConfig(["node_id" => $node_id]);
    }

    /**
     * 发放或查询符合规则的赠品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function executeRule (int $order_id, string $mode = 'execute') {
        return RpcClass::getClass(self::$serviceName, self::$className)->executeRule(["order_id" => $order_id, "mode" => $mode]);
    }

    /**
     * 发放或查询符合规则的赠品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function batchExecuteRule (array $orderIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchExecuteRule(["orderIds" => $orderIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}