<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-21 15:17:16
 */
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Order
 * @method hookCloseOrderByParams(array $params) 关闭订单
 * @method firstClickByParams(array $params) 第一次进入支付链接(仅限拍摄订单)
 * @method icbcPhotoByParams(array $params) icbc真我卡获取云端原片地址
 * @method orderCompleteByParams(array $params) 订单完成推送通知
 * @method sendKfMessageByParams(array $params) 婚礼照推送
 * @method photoTemplatesByParams(array $params) 获取照片模板
 * @method sendRetailKfMessageByParams(array $params) 零售客服消息
 * @method sendKidsMessageByParams(array $params) 小幸运kids营销推送
 * @method sendMantuXxzMessageByParams(array $params) 缦图形象照客服消息
 * @method paySuccessSendNoticeByParams(array $params) 支付成功推送
 * @method sendNormalNotifyByParams(array $params) 看片通知
 * @method sendMessageByParams(array $params) 推送客服消息
 * @method sendKfStoreQrMessageByParams(array $params) 推送客服消息
 */
class Order {
    private static string $serviceName = "HimoProduct";

    private static string $className = "User\\Order";

    /**
     * 关闭订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookCloseOrder (array $orderObject) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookCloseOrder(["orderObject" => $orderObject]);
    }

    /**
     * 第一次进入支付链接(仅限拍摄订单)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function firstClick (string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->firstClick(["orderNum" => $orderNum]);
    }

    /**
     * icbc真我卡获取云端原片地址
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function icbcPhoto (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->icbcPhoto(["user_id" => $user_id]);
    }

    /**
     * 订单完成推送通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function orderComplete (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderComplete(["orderId" => $orderId]);
    }

    /**
     * 婚礼照推送
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function sendKfMessage (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendKfMessage(["user_id" => $user_id]);
    }

    /**
     * 获取照片模板
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function photoTemplates (array $product_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->photoTemplates(["product_ids" => $product_ids]);
    }

    /**
     * 零售客服消息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function sendRetailKfMessage (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendRetailKfMessage(["user_id" => $user_id]);
    }

    /**
     * 小幸运kids营销推送
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function sendKidsMessage (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendKidsMessage(["user_id" => $user_id]);
    }

    /**
     * 缦图形象照客服消息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function sendMantuXxzMessage (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendMantuXxzMessage(["user_id" => $user_id]);
    }

    /**
     * 支付成功推送
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function paySuccessSendNotice (array $wxData) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paySuccessSendNotice(["wxData" => $wxData]);
    }

    /**
     * 看片通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function sendNormalNotify (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendNormalNotify(["order_id" => $order_id]);
    }

    /**
     * 推送客服消息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function sendMessage (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendMessage(["user_id" => $user_id]);
    }

    /**
     * 推送客服消息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function sendKfStoreQrMessage (int $user_id, string $media_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendKfStoreQrMessage(["user_id" => $user_id, "media_id" => $media_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}