<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-13 20:12:00
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Store
 * @method getAllStoreByParams(array $params) 获取所有门店
 * @method getAllAreasByParams(array $params) 获取所有城市（省市区，不包含街道）
 * @method getPriceAreasByParams(array $params) 获取门店价格区
 */
class Store {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Store\\Store";

    /**
     * 获取所有门店
     * @return  array
    */
    public static function getAllStore (?\Mainto\Bridge\Structs\HimoProduct\Store\Cmd\GetStoresCmd $getStoresCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAllStore($getStoresCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Store\DTO\StoreDTO[]"
        );
    }
    /**
     * 获取所有城市（省市区，不包含街道）
     * @return  array
    */
    public static function getAllAreas (?\Mainto\Bridge\Structs\HimoProduct\Store\Cmd\GetAllAreasCmd $getAllAreasCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAllAreas($getAllAreasCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Store\DTO\AreaDTO[]"
        );
    }
    /**
     * 获取门店价格区
     * @return  array
    */
    public static function getPriceAreas (\Mainto\Bridge\Structs\HimoProduct\Store\Cmd\GetPriceAreasCmd $getPriceAreasCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPriceAreas($getPriceAreasCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Store\DTO\StorePriceAreaDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}