<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-12 15:38:34
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ReservationLimit
 * @method listByParams(array $params) 限流配置列表
 * @method detailByParams(array $params) 单个限流配置详情
 * @method createByParams(array $params) 限流配置-新增
 * @method updateByParams(array $params) 限流配置-编辑
 * @method copyByParams(array $params) 限流配置-拷贝并新建
 * @method deleteByParams(array $params) 限流配置-删除
 * @method changeStatusByParams(array $params) 限流配置-上下线
 * @method rulesByParams(array $params) 获取限流规则
 * @method updateLimitReservationByParams(array $params) 更新限流排单表
 * @method getLimitReservationByParams(array $params) 获取限流规则下的排单表
 * @method deleteLimitReservationStoreCacheByParams(array $params) 清空限流规则下的排单表的缓存
 */
class ReservationLimit {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\ReservationLimit";

    /**
     * 限流配置列表
     * @return  array
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }
    /**
     * 单个限流配置详情
     * @return  array
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 限流配置-新增
     * @return  bool
    */
    public static function create (string $limit_type, string $brand, array $store_ids, array $product_ids, array $limit_config, string $status = 'off', string $limit_date_type, string $limit_range_type, string $limit_start_date, string $limit_end_date, array $limit_week_day) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["limit_type" => $limit_type, "brand" => $brand, "store_ids" => $store_ids, "product_ids" => $product_ids, "limit_config" => $limit_config, "status" => $status, "limit_date_type" => $limit_date_type, "limit_range_type" => $limit_range_type, "limit_start_date" => $limit_start_date, "limit_end_date" => $limit_end_date, "limit_week_day" => $limit_week_day]);
    }
    /**
     * 限流配置-编辑
     * @return  bool
    */
    public static function update (string $limit_type, string $brand, array $store_ids, array $product_ids, array $limit_config, string $status = 'off', string $limit_date_type, string $limit_range_type, string $limit_start_date, string $limit_end_date, array $limit_week_day) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["limit_type" => $limit_type, "brand" => $brand, "store_ids" => $store_ids, "product_ids" => $product_ids, "limit_config" => $limit_config, "status" => $status, "limit_date_type" => $limit_date_type, "limit_range_type" => $limit_range_type, "limit_start_date" => $limit_start_date, "limit_end_date" => $limit_end_date, "limit_week_day" => $limit_week_day]);
    }
    /**
     * 限流配置-拷贝并新建
     * @return  bool
    */
    public static function copy (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->copy(["id" => $id]);
    }
    /**
     * 限流配置-删除
     * @return  bool
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 限流配置-上下线
     * @return  bool
    */
    public static function changeStatus (int $id, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeStatus(["id" => $id, "status" => $status]);
    }
    /**
     * 获取限流规则
     * @return  mixed
    */
    public static function rules (int $storeId, array $productIds, string $startDate, string $endDate) {
        return RpcClass::getClass(self::$serviceName, self::$className)->rules(["storeId" => $storeId, "productIds" => $productIds, "startDate" => $startDate, "endDate" => $endDate]);
    }
    /**
     * 更新限流排单表
     * @return  bool
    */
    public static function updateLimitReservation (int $storeId, string $reserveTime, array $saleSkus, int $occupyNum, int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateLimitReservation(["storeId" => $storeId, "reserveTime" => $reserveTime, "saleSkus" => $saleSkus, "occupyNum" => $occupyNum, "orderId" => $orderId]);
    }
    /**
     * 获取限流规则下的排单表
     * @return  array
    */
    public static function getLimitReservation (array $storeIds, string $startDate, string $endDate, array $saleSkus, array $occupyNumArr) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLimitReservation(["storeIds" => $storeIds, "startDate" => $startDate, "endDate" => $endDate, "saleSkus" => $saleSkus, "occupyNumArr" => $occupyNumArr]);
    }
    /**
     * 清空限流规则下的排单表的缓存
     * @return  bool
    */
    public static function deleteLimitReservationStoreCache () {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteLimitReservationStoreCache();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}