<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-14 10:41:36
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PaymentOrder
 * @method createPaymentRequestByParams(array $params) 创建支付请求
 * @method getPaymentRequestDetailByParams(array $params) 获取支付请求详情
 * @method getPaymentRequestListByParams(array $params) 获取支付请求列表
 * @method resubmitPaymentRequestByParams(array $params) 重新付款
 * @method paymentFailByParams(array $params) 付款失败
 * @method getPaymentResultByParams(array $params) 获取结果
 * @method submitPaymentByParams(array $params) 提交付款
 * @method updatePaymentRequestByParams(array $params) 更新支付请求
 * @method getPaymentRequestByParams(array $params) 获取支付请求
 * @method paymentSuccessByParams(array $params) 付款成功
 * @method updateStatusByParams(array $params) 更新付款单状态
 */
class PaymentOrder {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\PaymentOrder";

    /**
     * 创建支付请求
     * @return  int
    */
    public static function createPaymentRequest (int $fromId, string $fromCode, float $money, string $proposer, string $departmentName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPaymentRequest(["fromId" => $fromId, "fromCode" => $fromCode, "money" => $money, "proposer" => $proposer, "departmentName" => $departmentName]);
    }
    /**
     * 获取支付请求详情
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\PaymentOrder\Dto\PaymentRequestDetailDto
    */
    public static function getPaymentRequestDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPaymentRequestDetail(["id" => $id]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\PaymentOrder\Dto\PaymentRequestDetailDto"
        );
    }
    /**
     * 获取支付请求列表
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\PaymentOrder\Dto\PaymentRequestListDto
    */
    public static function getPaymentRequestList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPaymentRequestList([]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\PaymentOrder\Dto\PaymentRequestListDto"
        );
    }
    /**
     * 重新付款
     * @return  bool
    */
    public static function resubmitPaymentRequest (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resubmitPaymentRequest(["id" => $id]);
    }
    /**
     * 付款失败
     * @return  bool
    */
    public static function paymentFail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paymentFail(["id" => $id]);
    }
    /**
     * 获取结果
     * @return  bool
    */
    public static function getPaymentResult (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPaymentResult(["id" => $id]);
    }
    /**
     * 提交付款
     * @return  bool
    */
    public static function submitPayment (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitPayment(["id" => $id]);
    }
    /**
     * 更新支付请求
     * @return  bool
    */
    public static function updatePaymentRequest (int $id, string $status, int $operator) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePaymentRequest(["id" => $id, "status" => $status, "operator" => $operator]);
    }
    /**
     * 获取支付请求
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\PaymentOrder\Dto\PaymentRequestDetailDto
    */
    public static function getPaymentRequest (string $fromCode) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPaymentRequest(["fromCode" => $fromCode]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\PaymentOrder\Dto\PaymentRequestDetailDto"
        );
    }
    /**
     * 付款成功
     * @return  bool
    */
    public static function paymentSuccess (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paymentSuccess(["id" => $id]);
    }
    /**
     * 更新付款单状态
     * @return  bool
    */
    public static function updateStatus (string $status, int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStatus(["status" => $status, "id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}