<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-14 10:41:36
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 * @method listByParams(array $params) 订单列表查询
 * @method globalSearchByParams(array $params) 全局订单列表查询
 * @method globalOrderDetailByParams(array $params) 获取全局订单详情
 * @method globalOrderPaperlessDetailByParams(array $params) 获取全局订单-无纸化详情
 * @method afterSaleOrderByParams(array $params) 获取订单关联的售后单
 * @method detailByParams(array $params) 获取订单详情
 * @method editOrderProductListByParams(array $params) 修改拍摄内容关闭的产品、升级服务在拍摄内容列表
 * @method getOrderTurnoversByParams(array $params) 获取订单流水
 * @method changePayTypeByParams(array $params) 财务修改支付方式
 * @method cloudOrderDetailByParams(array $params) 云端订单详情
 * @method changeNoteByParams(array $params) 修改订单备注
 * @method createByParams(array $params) 创建订单
 * @method userReachedByParams(array $params) 设置拍摄订单签到
 * @method modifyUserReachedByParams(array $params) 修改拍摄订单签到
 * @method setUserReachedPaidByParams(array $params) 设置签到完成支付
 * @method getUserReachedDetailByParams(array $params) 拍摄签到详情
 * @method unbindUserByParams(array $params) 取消绑定用户
 * @method updateUserByParams(array $params) 修改订单所属用户
 * @method cancelByParams(array $params) 取消订单
 * @method paidByParams(array $params) 完成支付
 * @method closeByParams(array $params) 关闭订单
 * @method setOrderClosedByRefundByParams(array $params) 把订单设置为退款关闭【只更改主订单状态】
 * @method startByParams(array $params) 开始订单
 * @method finishByParams(array $params) 完成订单（拍摄完成）
 * @method recoverWaitShootingByParams(array $params) 恢复到等待拍摄
 * @method recoverFinishedToWaitShootingByParams(array $params) 拍摄完成的订单恢复到等待拍摄
 * @method changeReserveTimeByParams(array $params) 修改预约时间
 * @method changeUserDataByParams(array $params) 修改用户数据
 * @method changeStoreByParams(array $params) 转门店
 * @method checkTransferStoreByParams(array $params) 转门店前检查
 * @method removeByParams(array $params) 删除订单
 * @method getCanUseCouponListByParams(array $params) 用户可用优惠券列表
 * @method getCanUseProductCardListByParams(array $params) 用户可用产品卡列表
 * @method getOrderJxjyCouponsByParams(array $params) 获取订单可用优惠券
 * @method jxjyCouponByParams(array $params) 获取用户加修加印券
 * @method getCouponInfoByParams(array $params) 获取优惠券详情
 * @method getProductCardInfoByParams(array $params) 获取产品券详情
 * @method calCouponDeductionInfoByParams(array $params) 计算优惠券可抵扣信息
 * @method calProductDeductionInfoByParams(array $params) 计算产品卡可抵扣信息
 * @method calInteriorCouponDeductionInfoByParams(array $params) 订单开单折扣码抵扣
 * @method operateLogByParams(array $params) 管理端查询订单操作记录
 * @method reserveProductCountByParams(array $params) 获取当日售卖产品总数
 * @method getEncryptOrderNumByParams(array $params) 获取加密订单号
 * @method getShortUrlByParams(array $params) 获取短链接
 * @method sendPayLinkByParams(array $params) 发送付款链接
 * @method orderClothByParams(array $params) 获取订单预选服装
 * @method orderClothsByOrderIdsByParams(array $params) 获取订单预选服装
 * @method updateOrderClothByParams(array $params) 门店最终选衣
 * @method itemOrderClothByParams(array $params) 门店换产品处理选衣
 * @method yuanYangCodeByParams(array $params) 查询鸳鸯照码的发送情况
 * @method partRefundNoteByParams(array $params) 退款订单备注
 * @method useGiftCardMoneyByParams(array $params) 修改使用礼品卡金额
 * @method useMarketCardMoneyByParams(array $params) 修改使用商场卡金额
 * @method sendGiftCardPayDsConfirmPushByParams(array $params) 使用礼品卡支付确认的推送
 * @method sendGiftCardNotifyByParams(array $params) 发送礼品卡使用通知
 * @method listByPayByParams(array $params) 查账助手-根据订单类型获取
 * @method getStoreProductByParams(array $params) 获取门店产品树
 * @method getBaseRetakeInfoByParams(array $params) 获取重拍订单的基础信息
 * @method getInfoAndTurnoversByParams(array $params) 获取订单信息及流水
 * @method editDSInputStaffByParams(array $params) 修改一、二销主推
 * @method getDSInputStaffByParams(array $params) 获取二销主推人
 * @method getOrderDiscountChangeInfoByParams(array $params) 获取修改预约时间订单优惠发生变化信息
 * @method isNeedChargeByParams(array $params) 是否需要手续费
 * @method getOrderUseSpecialDiscountTypeByParams(array $params) 获取订单使用的特殊折扣类型
 * @method specialDiscountReasonsByParams(array $params) 获取顾客自定义折扣
 */
class Order {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Order";

    /**
     * 订单列表查询
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }
    /**
     * 全局订单列表查询
     * @return  mixed
    */
    public static function globalSearch () {
        return RpcClass::getClass(self::$serviceName, self::$className)->globalSearch([]);
    }
    /**
     * 获取全局订单详情
     * @return  mixed
    */
    public static function globalOrderDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->globalOrderDetail(["id" => $id]);
    }
    /**
     * 获取全局订单-无纸化详情
     * @return  mixed
    */
    public static function globalOrderPaperlessDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->globalOrderPaperlessDetail(["id" => $id]);
    }
    /**
     * 获取订单关联的售后单
     * @return  mixed
    */
    public static function afterSaleOrder (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterSaleOrder(["id" => $id]);
    }
    /**
     * 获取订单详情
     * @return  mixed
    */
    public static function detail (int $id, string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, "orderNo" => $orderNo]);
    }
    /**
     * 修改拍摄内容关闭的产品、升级服务在拍摄内容列表
     * @return  array
    */
    public static function editOrderProductList (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->editOrderProductList(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Order\Dto\EditOrderProductListDto[]"
        );
    }
    /**
     * 获取订单流水
     * @return  mixed
    */
    public static function getOrderTurnovers (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderTurnovers(["orderNo" => $orderNo]);
    }
    /**
     * 财务修改支付方式
     * @return  mixed
    */
    public static function changePayType (int $id, string $payType, int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "payType" => $payType, "orderId" => $orderId]);
    }
    /**
     * 云端订单详情
     * @return  mixed
    */
    public static function cloudOrderDetail (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cloudOrderDetail(["order_no" => $order_no]);
    }
    /**
     * 修改订单备注
     * @return  mixed
    */
    public static function changeNote (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeNote(["id" => $id]);
    }
    /**
     * 创建订单
     * @return  mixed
    */
    public static function create (float $money, float $realMoney, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["money" => $money, "realMoney" => $realMoney, "type" => $type]);
    }
    /**
     * 设置拍摄订单签到
     * @return  mixed
    */
    public static function userReached (int $orderId, int $reachedPeopleNum, bool $needMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->userReached(["orderId" => $orderId, "reachedPeopleNum" => $reachedPeopleNum, "needMoney" => $needMoney]);
    }
    /**
     * 修改拍摄订单签到
     * @return  mixed
    */
    public static function modifyUserReached (int $orderId, int $orderDiffId, int $reachedPeopleNum, bool $needMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyUserReached(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "reachedPeopleNum" => $reachedPeopleNum, "needMoney" => $needMoney]);
    }
    /**
     * 设置签到完成支付
     * @return  mixed
    */
    public static function setUserReachedPaid (int $orderId, int $orderDiffId, string $payType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setUserReachedPaid(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "payType" => $payType]);
    }
    /**
     * 拍摄签到详情
     * @return  mixed
    */
    public static function getUserReachedDetail (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserReachedDetail(["orderId" => $orderId]);
    }
    /**
     * 取消绑定用户
     * @return  mixed
    */
    public static function unbindUser (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unbindUser(["id" => $id]);
    }
    /**
     * 修改订单所属用户
     * @return  mixed
    */
    public static function updateUser (string $order_num, string $phone, string $bindReason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateUser(["order_num" => $order_num, "phone" => $phone, "bindReason" => $bindReason]);
    }
    /**
     * 取消订单
     * @return  bool
    */
    public static function cancel (int $id, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["id" => $id, "reason" => $reason]);
    }
    /**
     * 完成支付
     * @return  bool
    */
    public static function paid (int $id, int $orderDiffId, string $payType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paid(["id" => $id, "orderDiffId" => $orderDiffId, "payType" => $payType]);
    }
    /**
     * 关闭订单
     * @return  mixed
    */
    public static function close (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["id" => $id]);
    }
    /**
     * 把订单设置为退款关闭【只更改主订单状态】
     * @return  mixed
    */
    public static function setOrderClosedByRefund (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setOrderClosedByRefund(["order_no" => $order_no]);
    }
    /**
     * 开始订单
     * @return  mixed
    */
    public static function start (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->start(["id" => $id]);
    }
    /**
     * 完成订单（拍摄完成）
     * @return  mixed
    */
    public static function finish (int $id, array $workloads) {
        return RpcClass::getClass(self::$serviceName, self::$className)->finish(["id" => $id, "workloads" => $workloads]);
    }
    /**
     * 恢复到等待拍摄
     * @return  mixed
    */
    public static function recoverWaitShooting (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->recoverWaitShooting(["id" => $id]);
    }
    /**
     * 拍摄完成的订单恢复到等待拍摄
     * @return  mixed
    */
    public static function recoverFinishedToWaitShooting (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->recoverFinishedToWaitShooting(["id" => $id]);
    }
    /**
     * 修改预约时间
     * @return  mixed
    */
    public static function changeReserveTime (int $id, string $reserve_time) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeReserveTime(["id" => $id, "reserve_time" => $reserve_time]);
    }
    /**
     * 修改用户数据
     * @return  mixed
    */
    public static function changeUserData (int $id, string $user_name, string $user_sex) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserData(["id" => $id, "user_name" => $user_name, "user_sex" => $user_sex]);
    }
    /**
     * 转门店
     * @return  mixed
    */
    public static function changeStore (int $id, int $storeId, string $reserveTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeStore(["id" => $id, "storeId" => $storeId, "reserveTime" => $reserveTime]);
    }
    /**
     * 转门店前检查
     * @return  bool
    */
    public static function checkTransferStore (int $id, int $storeId, string $reserveTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkTransferStore(["id" => $id, "storeId" => $storeId, "reserveTime" => $reserveTime]);
    }
    /**
     * 删除订单
     * @return  mixed
    */
    public static function remove (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id]);
    }
    /**
     * 用户可用优惠券列表
     * @return  mixed
    */
    public static function getCanUseCouponList (array $product_ids, int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCanUseCouponList(["product_ids" => $product_ids, "user_id" => $user_id]);
    }
    /**
     * 用户可用产品卡列表
     * @return  mixed
    */
    public static function getCanUseProductCardList (array $product_ids, int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCanUseProductCardList(["product_ids" => $product_ids, "user_id" => $user_id]);
    }
    /**
     * 获取订单可用优惠券
     * @return  array
    */
    public static function getOrderJxjyCoupons () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderJxjyCoupons([]);
    }
    /**
     * 获取用户加修加印券
     * @return  mixed
    */
    public static function jxjyCoupon (array $product_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->jxjyCoupon(["product_ids" => $product_ids]);
    }
    /**
     * 获取优惠券详情
     * @return  mixed
    */
    public static function getCouponInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponInfo(["id" => $id]);
    }
    /**
     * 获取产品券详情
     * @return  mixed
    */
    public static function getProductCardInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCardInfo(["id" => $id]);
    }
    /**
     * 计算优惠券可抵扣信息
     * @return  mixed
    */
    public static function calCouponDeductionInfo (array $detail, int $coupon_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calCouponDeductionInfo(["detail" => $detail, "coupon_id" => $coupon_id]);
    }
    /**
     * 计算产品卡可抵扣信息
     * @return  mixed
    */
    public static function calProductDeductionInfo (array $detail, int $product_card_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calProductDeductionInfo(["detail" => $detail, "product_card_id" => $product_card_id]);
    }
    /**
     * 订单开单折扣码抵扣
     * @return  mixed
    */
    public static function calInteriorCouponDeductionInfo (string $interior_coupon_code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calInteriorCouponDeductionInfo(["interior_coupon_code" => $interior_coupon_code]);
    }
    /**
     * 管理端查询订单操作记录
     * @return  mixed
    */
    public static function operateLog (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->operateLog(["order_id" => $order_id]);
    }
    /**
     * 获取当日售卖产品总数
     * @return  mixed
    */
    public static function reserveProductCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->reserveProductCount([]);
    }
    /**
     * 获取加密订单号
     * @return  mixed
    */
    public static function getEncryptOrderNum (string $order_num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEncryptOrderNum(["order_num" => $order_num]);
    }
    /**
     * 获取短链接
     * @return  mixed
    */
    public static function getShortUrl (string $order_num, string $url) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShortUrl(["order_num" => $order_num, "url" => $url]);
    }
    /**
     * 发送付款链接
     * @return  mixed
    */
    public static function sendPayLink (int $orderId, string $url, string $orderType, string $phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendPayLink(["orderId" => $orderId, "url" => $url, "orderType" => $orderType, "phone" => $phone]);
    }
    /**
     * 获取订单预选服装
     * @return  mixed
    */
    public static function orderCloth (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderCloth(["order_id" => $order_id]);
    }
    /**
     * 获取订单预选服装
     * @return  mixed
    */
    public static function orderClothsByOrderIds (array $orderIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderClothsByOrderIds(["orderIds" => $orderIds]);
    }
    /**
     * 门店最终选衣
     * @return  mixed
    */
    public static function updateOrderCloth (int $order_id, int $item_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateOrderCloth(["order_id" => $order_id, "item_id" => $item_id]);
    }
    /**
     * 门店换产品处理选衣
     * @return  mixed
    */
    public static function itemOrderCloth (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->itemOrderCloth(["order_id" => $order_id]);
    }
    /**
     * 查询鸳鸯照码的发送情况
     * @return  mixed
    */
    public static function yuanYangCode () {
        return RpcClass::getClass(self::$serviceName, self::$className)->yuanYangCode([]);
    }
    /**
     * 退款订单备注
     * @return  mixed
    */
    public static function partRefundNote (string $order_no, float $money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->partRefundNote(["order_no" => $order_no, "money" => $money]);
    }
    /**
     * 修改使用礼品卡金额
     * @return  mixed
    */
    public static function useGiftCardMoney (int $id, float $giftCardPayMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->useGiftCardMoney(["id" => $id, "giftCardPayMoney" => $giftCardPayMoney]);
    }
    /**
     * 修改使用商场卡金额
     * @return  mixed
    */
    public static function useMarketCardMoney (int $id, float $marketCardMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->useMarketCardMoney(["id" => $id, "marketCardMoney" => $marketCardMoney]);
    }
    /**
     * 使用礼品卡支付确认的推送
     * @return  bool
    */
    public static function sendGiftCardPayDsConfirmPush (int $id, float $giftCardMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendGiftCardPayDsConfirmPush(["id" => $id, "giftCardMoney" => $giftCardMoney]);
    }
    /**
     * 发送礼品卡使用通知
     * @return  mixed
    */
    public static function sendGiftCardNotify (int $id, float $giftCardMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendGiftCardNotify(["id" => $id, "giftCardMoney" => $giftCardMoney]);
    }
    /**
     * 查账助手-根据订单类型获取
     * @return  mixed
    */
    public static function listByPay (string $paidAtStart, string $paidAtEnd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listByPay(["paidAtStart" => $paidAtStart, "paidAtEnd" => $paidAtEnd]);
    }
    /**
     * 获取门店产品树
     * @return  mixed
    */
    public static function getStoreProduct () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreProduct([]);
    }
    /**
     * 获取重拍订单的基础信息
     * @return  mixed
    */
    public static function getBaseRetakeInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBaseRetakeInfo([]);
    }
    /**
     * 获取订单信息及流水
     * @return  mixed
    */
    public static function getInfoAndTurnovers (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfoAndTurnovers(["orderNo" => $orderNo]);
    }
    /**
     * 修改一、二销主推
     * @return  mixed
    */
    public static function editDSInputStaff (int $orderId, int $turnoverId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editDSInputStaff(["orderId" => $orderId, "turnoverId" => $turnoverId]);
    }
    /**
     * 获取二销主推人
     * @return  mixed
    */
    public static function getDSInputStaff (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDSInputStaff(["orderNo" => $orderNo]);
    }
    /**
     * 获取修改预约时间订单优惠发生变化信息
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Order\Dto\GetOrderDiscountChangeInfoDTO
    */
    public static function getOrderDiscountChangeInfo (int $orderId, string $reserveTime) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderDiscountChangeInfo(["orderId" => $orderId, "reserveTime" => $reserveTime]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Order\Dto\GetOrderDiscountChangeInfoDTO"
        );
    }
    /**
     * 是否需要手续费
     * @return  mixed
    */
    public static function isNeedCharge (string $appointAt, string $option) {
        return RpcClass::getClass(self::$serviceName, self::$className)->isNeedCharge(["appointAt" => $appointAt, "option" => $option]);
    }
    /**
     * 获取订单使用的特殊折扣类型
     * @return  string
    */
    public static function getOrderUseSpecialDiscountType () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderUseSpecialDiscountType([]);
    }
    /**
     * 获取顾客自定义折扣
     * @return  array
    */
    public static function specialDiscountReasons (\Mainto\Bridge\Structs\HimoProduct\Admin\Order\Cmd\SpecialDiscountReasonsCmd $specialDiscountReasonsCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->specialDiscountReasons($specialDiscountReasonsCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}