<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-12 16:51:56
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Channel
 * @method addByParams(array $params) 新增渠道
 * @method updateByParams(array $params) 更新渠道信息
 * @method listByParams(array $params) 渠道号列表
 * @method deleteByParams(array $params) 删除渠道
 * @method qrcodeByParams(array $params) 获取渠道二维码
 */
class Channel {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Channel";

    /**
     * 新增渠道
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Channel\Dto\ChannelDto
    */
    public static function add (string $name, int $channel_num) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->add(["name" => $name, "channel_num" => $channel_num]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Channel\Dto\ChannelDto"
        );
    }
    /**
     * 更新渠道信息
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Channel\Dto\ChannelDto
    */
    public static function update (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Channel\Dto\ChannelDto"
        );
    }
    /**
     * 渠道号列表
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }
    /**
     * 删除渠道
     * @return  mixed
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 获取渠道二维码
     * @return  mixed
    */
    public static function qrcode (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->qrcode(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}