<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-12 16:51:56
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Announcement
 * @method announcementPublisherByParams(array $params) 获取公告发布人
 * @method getRolesByParams(array $params) 获取公告接收角色
 * @method announcementListByParams(array $params) 获取公告列表
 * @method announcementListWithPageByParams(array $params) 获取公告列表(分页)
 * @method createAnnouncementByParams(array $params) 创建公告
 * @method editAnnouncementByParams(array $params) 编辑公告
 * @method announcementDetailByParams(array $params) 公告详情
 * @method abolishByParams(array $params) 作废公告
 * @method exportReadReportByParams(array $params) 导出公告阅读报告
 * @method getPopsByParams(array $params) 获取指定日期的弹窗
 * @method readAnnouncementByParams(array $params) 读公告
 * @method getWaitReadMessagesByParams(array $params) 获取未读消息ids
 * @method createAnnouncementCategoryByParams(array $params) 创建公告板块
 * @method editAnnouncementCategoryByParams(array $params) 编辑公告板块
 * @method deleteAnnouncementCategoryByParams(array $params) 删除公告板块
 * @method getAnnouncementCategoryByParams(array $params) 获取公告板块
 * @method departmentTreeByParams(array $params) 获取公告部门树
 * @method sendUnreadMessageByParams(array $params) 发送未读消息
 * @method batchTopByParams(array $params) 批量更新公告置顶状态
 */
class Announcement {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Announcement";

    /**
     * 获取公告发布人
     * @return  array
    */
    public static function announcementPublisher () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->announcementPublisher(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\PublisherDto[]"
        );
    }
    /**
     * 获取公告接收角色
     * @return  array
    */
    public static function getRoles () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRoles();
    }
    /**
     * 获取公告列表
     * @return  array
    */
    public static function announcementList (?\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementSearch $announcementSearch = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->announcementList($announcementSearch),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\Announcement[]"
        );
    }
    /**
     * 获取公告列表(分页)
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\AnnouncementListWithPage
    */
    public static function announcementListWithPage (?\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementSearch $announcementSearch = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->announcementListWithPage($announcementSearch),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\AnnouncementListWithPage"
        );
    }
    /**
     * 创建公告
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\Announcement
    */
    public static function createAnnouncement (\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementCreate $announcementCreate) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createAnnouncement($announcementCreate),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\Announcement"
        );
    }
    /**
     * 编辑公告
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\Announcement
    */
    public static function editAnnouncement (\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementEdit $announcementEdit) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->editAnnouncement($announcementEdit),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\Announcement"
        );
    }
    /**
     * 公告详情
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\AnnouncementAppendInfo
    */
    public static function announcementDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->announcementDetail(["id" => $id]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\AnnouncementAppendInfo"
        );
    }
    /**
     * 作废公告
     * @return  bool
    */
    public static function abolish (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolish(["id" => $id]);
    }
    /**
     * 导出公告阅读报告
     * @return  array
    */
    public static function exportReadReport (array $messageIds) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->exportReadReport(["messageIds" => $messageIds]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\ReadReport[]"
        );
    }
    /**
     * 获取指定日期的弹窗
     * @return  array
    */
    public static function getPops (string $date) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPops(["date" => $date]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\Announcement[]"
        );
    }
    /**
     * 读公告
     * @return  bool
    */
    public static function readAnnouncement (int $reader, int $messageId, string $readerType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->readAnnouncement(["reader" => $reader, "messageId" => $messageId, "readerType" => $readerType]);
    }
    /**
     * 获取未读消息ids
     * @return  array
    */
    public static function getWaitReadMessages (int $reader) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWaitReadMessages(["reader" => $reader]);
    }
    /**
     * 创建公告板块
     * @return  bool
    */
    public static function createAnnouncementCategory (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createAnnouncementCategory(["name" => $name]);
    }
    /**
     * 编辑公告板块
     * @return  bool
    */
    public static function editAnnouncementCategory (\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementCategoryEdit $announcementCategoryEdit) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editAnnouncementCategory($announcementCategoryEdit);
    }
    /**
     * 删除公告板块
     * @return  bool
    */
    public static function deleteAnnouncementCategory (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteAnnouncementCategory(["id" => $id]);
    }
    /**
     * 获取公告板块
     * @return  array
    */
    public static function getAnnouncementCategory () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAnnouncementCategory(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\AnnouncementCategory[]"
        );
    }
    /**
     * 获取公告部门树
     * @return  array
    */
    public static function departmentTree () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->departmentTree([]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\DepartmentTree[]"
        );
    }
    /**
     * 发送未读消息
     * @return  bool
    */
    public static function sendUnreadMessage (string $messageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendUnreadMessage(["messageId" => $messageId]);
    }
    /**
     * 批量更新公告置顶状态
     * @return  bool
    */
    public static function batchTop (array $ids, int $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchTop(["ids" => $ids, "status" => $status]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}