<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-14 16:21:25
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ProductCardOrder
 * @method listByParams(array $params) 获取产品卡订单列表
 * @method inputByParams(array $params) 产品卡订单录入
 * @method detailByParams(array $params) 产品卡订单详情
 * @method canSaleCardListByParams(array $params) 可售产品卡列表
 * @method detailByNumByParams(array $params) 通过订单号获取产品卡订单详情
 * @method changePayTypeByParams(array $params) 财务修改支付方式
 * @method calProductCardPriceByParams(array $params) 计算产品卡价格 
 * @method calProductCardsPriceByParams(array $params) 计算产品卡价格 
 * @method checkProductCardsMoneyByParams(array $params) 检验产品卡价格
 */
class ProductCardOrder {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\ProductCardOrder";

    /**
     * 获取产品卡订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }

    /**
     * 产品卡订单录入
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function input (string $user_name, string $phone, string $sex, string $pay_type, float $ori_money, float $pay_money, string $buy_channel = 'headquarters') {
        return RpcClass::getClass(self::$serviceName, self::$className)->input(["user_name" => $user_name, "phone" => $phone, "sex" => $sex, "pay_type" => $pay_type, "ori_money" => $ori_money, "pay_money" => $pay_money, "buy_channel" => $buy_channel]);
    }

    /**
     * 产品卡订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 可售产品卡列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function canSaleCardList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->canSaleCardList([]);
    }

    /**
     * 通过订单号获取产品卡订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detailByNum (string $order_num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailByNum(["order_num" => $order_num]);
    }

    /**
     * 财务修改支付方式
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function changePayType (int $id, string $pay_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "pay_type" => $pay_type]);
    }

    /**
     * 计算产品卡价格 
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function calProductCardPrice (array $limit) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calProductCardPrice(["limit" => $limit]);
    }

    /**
     * 计算产品卡价格 
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function calProductCardsPrice (array $cardIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calProductCardsPrice(["cardIds" => $cardIds]);
    }

    /**
     * 检验产品卡价格
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function checkProductCardsMoney (array $cardIds, float $payMoney, float $oriMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkProductCardsMoney(["cardIds" => $cardIds, "payMoney" => $payMoney, "oriMoney" => $oriMoney]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}