<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-13 19:29:15
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Permission
 * @method listByParams(array $params) 获取所有权限列表
 * @method addByParams(array $params) 创建权限
 * @method deleteByParams(array $params) 删除权限
 */
class Permission {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Permission";

    /**
     * 获取所有权限列表
     * @return  array
    */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list([]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Permission\Dto\PermissionListDto[]"
        );
    }
    /**
     * 创建权限
     * @return  bool
    */
    public static function add (int $staff_id, string $name, string $title, string $desc) {
        return RpcClass::getClass(self::$serviceName, self::$className)->add(["staff_id" => $staff_id, "name" => $name, "title" => $title, "desc" => $desc]);
    }
    /**
     * 删除权限
     * @return  bool
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}