<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-07 14:20:29
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class StoreClassification
 * @method listByParams(array $params) 根据类型获取分类列表
 * @method typesByParams(array $params) 获取分类类型列表
 * @method bindByParams(array $params) 分类绑定门店
 * @method createByParams(array $params) 创建地区分类
 * @method updateByParams(array $params) 修改分类
 * @method detailByParams(array $params) 分类详情
 * @method getClassificationStoreByParams(array $params) 获取某些门店分类下的门店列表
 */
class StoreClassification {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\StoreClassification";

    /**
     * 根据类型获取分类列表
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }
    /**
     * 获取分类类型列表
     * @return  mixed
    */
    public static function types () {
        return RpcClass::getClass(self::$serviceName, self::$className)->types();
    }
    /**
     * 分类绑定门店
     * @return  mixed
    */
    public static function bind (int $id, array $store_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bind(["id" => $id, "store_ids" => $store_ids]);
    }
    /**
     * 创建地区分类
     * @return  mixed
    */
    public static function create (string $type, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["type" => $type, "name" => $name]);
    }
    /**
     * 修改分类
     * @return  mixed
    */
    public static function update (int $id, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "name" => $name]);
    }
    /**
     * 分类详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 获取某些门店分类下的门店列表
     * @return  mixed
    */
    public static function getClassificationStore (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getClassificationStore(["ids" => $ids]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}