<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-07 14:20:29
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Nps
 * @method staffByParams(array $params) 个人nps数据统计
 * @method storeByParams(array $params) 门店nps数据统计
 * @method detailByParams(array $params) 获取订单nps详情
 * @method notEvaluateByParams(array $params) 获取未评价nps的订单
 * @method editByParams(array $params) nps修改
 */
class Nps {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Nps";

    /**
     * 个人nps数据统计
     * @return  mixed
    */
    public static function staff (string $start_time, string $end_time, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->staff(["start_time" => $start_time, "end_time" => $end_time, "store_id" => $store_id]);
    }
    /**
     * 门店nps数据统计
     * @return  mixed
    */
    public static function store (string $start_time, string $end_time, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->store(["start_time" => $start_time, "end_time" => $end_time, "store_id" => $store_id]);
    }
    /**
     * 获取订单nps详情
     * @return  mixed
    */
    public static function detail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail([]);
    }
    /**
     * 获取未评价nps的订单
     * @return  mixed
    */
    public static function notEvaluate (string $start_time, string $end_time, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->notEvaluate(["start_time" => $start_time, "end_time" => $end_time, "store_id" => $store_id]);
    }
    /**
     * nps修改
     * @return  mixed
    */
    public static function edit (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->edit(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}