<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-07 17:04:25
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SupplyChain
 * @method getSupplyChainStaffsByParams(array $params) 获取供应链员工列表
 * @method getSubjectsByParams(array $params) 获取子公司数据
 * @method getStockCountByParams(array $params) 根据类型获取物料数量
 * @method submitByParams(array $params) 提交盘点结果(总部)
 * @method getInventoriesByParams(array $params) 获取盘点数据记录
 * @method getInventoryByParams(array $params) 获取盘点记录详情
 * @method saveByParams(array $params) 保存
 * @method passByParams(array $params) 通过
 * @method rejectByParams(array $params) 驳回
 * @method deleteInventoryByParams(array $params) 删除盘点记录
 * @method exportInventoryByParams(array $params) 盘点导出
 * @method getStocksByParams(array $params) 获取库存数据
 * @method getStockByParams(array $params) 获取库存
 * @method exportStockByParams(array $params) 库存导出
 */
class SupplyChain {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\SupplyChain";

    /**
     * 获取供应链员工列表
     * @return  mixed
    */
    public static function getSupplyChainStaffs () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupplyChainStaffs();
    }
    /**
     * 获取子公司数据
     * @return  mixed
    */
    public static function getSubjects () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSubjects();
    }
    /**
     * 根据类型获取物料数量
     * @return  array
    */
    public static function getStockCount (string $locType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockCount(["locType" => $locType]);
    }
    /**
     * 提交盘点结果(总部)
     * @return  bool
    */
    public static function submit (int $staffId, int $locType, array $materialInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submit(["staffId" => $staffId, "locType" => $locType, "materialInfo" => $materialInfo]);
    }
    /**
     * 获取盘点数据记录
     * @return  array
    */
    public static function getInventories () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInventories([]);
    }
    /**
     * 获取盘点记录详情
     * @return  array
    */
    public static function getInventory (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInventory(["id" => $id]);
    }
    /**
     * 保存
     * @return  bool
    */
    public static function save (int $id, array $info) {
        return RpcClass::getClass(self::$serviceName, self::$className)->save(["id" => $id, "info" => $info]);
    }
    /**
     * 通过
     * @return  bool
    */
    public static function pass (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pass(["ids" => $ids]);
    }
    /**
     * 驳回
     * @return  bool
    */
    public static function reject (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reject(["ids" => $ids]);
    }
    /**
     * 删除盘点记录
     * @return  bool
    */
    public static function deleteInventory (array $inventoryIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteInventory(["inventoryIds" => $inventoryIds]);
    }
    /**
     * 盘点导出
     * @return  array
    */
    public static function exportInventory () {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportInventory([]);
    }
    /**
     * 获取库存数据
     * @return  array
    */
    public static function getStocks () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStocks([]);
    }
    /**
     * 获取库存
     * @return  array
    */
    public static function getStock (int $storeId, int $skuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStock(["storeId" => $storeId, "skuId" => $skuId]);
    }
    /**
     * 库存导出
     * @return  array
    */
    public static function exportStock () {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportStock([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}