<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-07 17:04:25
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OtherOrderRefund
 * @method createByParams(array $params) 创建其它订单退款
 * @method listByParams(array $params) 获取其它订单退款列表
 * @method detailByParams(array $params) 获取其它订单退款详情
 * @method passByParams(array $params) 通过其它订单退款申请
 * @method rejectByParams(array $params) 拒绝过其它订单退款申请
 */
class OtherOrderRefund {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\OtherOrderRefund";

    /**
     * 创建其它订单退款
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OtherOrderRefund\ListDetailDto
    */
    public static function create (string $people, string $account, string $reason, float $money) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->create(["people" => $people, "account" => $account, "reason" => $reason, "money" => $money]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OtherOrderRefund\ListDetailDto"
        );
    }
    /**
     * 获取其它订单退款列表
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OtherOrderRefund\ListDto
    */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list([]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OtherOrderRefund\ListDto"
        );
    }
    /**
     * 获取其它订单退款详情
     * @return  array
    */
    public static function detail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail([]);
    }
    /**
     * 通过其它订单退款申请
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OtherOrderRefund\ListDetailDto
    */
    public static function pass (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->pass(["id" => $id]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OtherOrderRefund\ListDetailDto"
        );
    }
    /**
     * 拒绝过其它订单退款申请
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OtherOrderRefund\ListDetailDto
    */
    public static function reject () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->reject([]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OtherOrderRefund\ListDetailDto"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}