<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-19 18:04:08
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Marketing;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PreferentialCard
 * @method getLogsByParams(array $params) 优惠券管理-优惠券创建记录查询
 * @method detailByParams(array $params) 优惠券管理-详情
 * @method createByParams(array $params) 优惠券管理-申请制券
 * @method cancelAuditByParams(array $params) 优惠券管理-撤回审批
 * @method codeListByParams(array $params) 获取券码列表(分页)
 * @method codeAllByParams(array $params) 获取券码列表(所有)
 */
class PreferentialCard {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Marketing\\PreferentialCard";

    /**
     * 优惠券管理-优惠券创建记录查询
     * @return  array
    */
    public static function getLogs (string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLogs(["status" => $status]);
    }
    /**
     * 优惠券管理-详情
     * @return  mixed
    */
    public static function detail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail([]);
    }
    /**
     * 优惠券管理-申请制券
     * @return  bool
    */
    public static function create (\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\PreferentialCouponCmd $preferentialCouponCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($preferentialCouponCmd);
    }
    /**
     * 优惠券管理-撤回审批
     * @return  bool
    */
    public static function cancelAudit (int $audit_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelAudit(["audit_id" => $audit_id]);
    }
    /**
     * 获取券码列表(分页)
     * @return  array
    */
    public static function codeList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->codeList([]);
    }
    /**
     * 获取券码列表(所有)
     * @return  array
    */
    public static function codeAll () {
        return RpcClass::getClass(self::$serviceName, self::$className)->codeAll([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}