<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-19 18:04:08
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Store
 * @method listByParams(array $params) 获取门店列表
 * @method exportByParams(array $params) 门店列表信息导出
 * @method cityByParams(array $params) 获取有门店的所有城市
 * @method allByParams(array $params) 根据分组获取门店(不传参数则为全部)
 * @method createByParams(array $params) 创建门店
 * @method detailByParams(array $params) 获取门店信息
 * @method managersByParams(array $params) 获取所有区域经理
 * @method updateByParams(array $params) 修改门店信息
 * @method noReleaseByParams(array $params) 门店下线
 * @method releaseByParams(array $params) 门店上线
 * @method getDepartmentListByParams(array $params) 获取部门列表
 * @method hookStoreUsePosStatusByParams(array $params) 门店pos绑定事件
 * @method getNotOpenStoreAllByParams(array $params) 获取所有未营业门店
 * @method batchSetAllNotOpenStoreByParams(array $params) 批量设置所有未营业门店
 * @method getCityIdsByPriceAreaIdsByParams(array $params) 根据价格区获取城市ids
 * @method getGroupsByParams(array $params) 集团列表
 */
class Store {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Store";

    /**
     * 获取门店列表
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }
    /**
     * 门店列表信息导出
     * @return  mixed
    */
    public static function export () {
        return RpcClass::getClass(self::$serviceName, self::$className)->export();
    }
    /**
     * 获取有门店的所有城市
     * @return  mixed
    */
    public static function city () {
        return RpcClass::getClass(self::$serviceName, self::$className)->city([]);
    }
    /**
     * 根据分组获取门店(不传参数则为全部)
     * @return  mixed
    */
    public static function all () {
        return RpcClass::getClass(self::$serviceName, self::$className)->all([]);
    }
    /**
     * 创建门店
     * @return  mixed
    */
    public static function create (string $name, int $city_id, int $sc_id, int $province_id, int $dept_id, string $affiliate_type, string $start_appointment_time, string $stop_appointment_time,  $extend, int $service_interval, int $service_times, string $start_business, int $sort) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "city_id" => $city_id, "sc_id" => $sc_id, "province_id" => $province_id, "dept_id" => $dept_id, "affiliate_type" => $affiliate_type, "start_appointment_time" => $start_appointment_time, "stop_appointment_time" => $stop_appointment_time, "extend" => $extend, "service_interval" => $service_interval, "service_times" => $service_times, "start_business" => $start_business, "sort" => $sort]);
    }
    /**
     * 获取门店信息
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 获取所有区域经理
     * @return  mixed
    */
    public static function managers () {
        return RpcClass::getClass(self::$serviceName, self::$className)->managers();
    }
    /**
     * 修改门店信息
     * @return  bool
    */
    public static function update (string $name, int $city_id, int $sc_id, int $province_id, int $id, string $affiliate_type, string $start_appointment_time, string $stop_appointment_time,  $extend, int $sort) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["name" => $name, "city_id" => $city_id, "sc_id" => $sc_id, "province_id" => $province_id, "id" => $id, "affiliate_type" => $affiliate_type, "start_appointment_time" => $start_appointment_time, "stop_appointment_time" => $stop_appointment_time, "extend" => $extend, "sort" => $sort]);
    }
    /**
     * 门店下线
     * @return  mixed
    */
    public static function noRelease (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->noRelease(["id" => $id]);
    }
    /**
     * 门店上线
     * @return  bool
    */
    public static function release (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->release(["id" => $id]);
    }
    /**
     * 获取部门列表
     * @return  mixed
    */
    public static function getDepartmentList (string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDepartmentList(["type" => $type]);
    }
    /**
     * 门店pos绑定事件
     * @return  mixed
    */
    public static function hookStoreUsePosStatus (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookStoreUsePosStatus(["storeId" => $storeId]);
    }
    /**
     * 获取所有未营业门店
     * @return  mixed
    */
    public static function getNotOpenStoreAll () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNotOpenStoreAll();
    }
    /**
     * 批量设置所有未营业门店
     * @return  bool
    */
    public static function batchSetAllNotOpenStore () {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchSetAllNotOpenStore([]);
    }
    /**
     * 根据价格区获取城市ids
     * @return  mixed
    */
    public static function getCityIdsByPriceAreaIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCityIdsByPriceAreaIds([]);
    }
    /**
     * 集团列表
     * @return  mixed
    */
    public static function getGroups () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroups([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}