<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-12 10:20:56
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Marketing;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductCard
 * @method getLogsByParams(array $params) 产品卡创建记录查询
 * @method detailByParams(array $params) 产品卡管理-详情
 * @method createPhysicalByParams(array $params) 产品卡管理-创建实体卡-无需审批
 * @method createVirtualByParams(array $params) 产品卡管理-创建产品券
 * @method cancelAuditByParams(array $params) 优惠券管理-撤回审批
 * @method codeListByParams(array $params) 获取产品卡列表(分页)
 * @method codeAllByParams(array $params) 获取产品卡列表(所有)
 */
class ProductCard {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Marketing\\ProductCard";

    /**
     * 产品卡创建记录查询
     * @return  mixed
    */
    public static function getLogs (string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLogs(["status" => $status]);
    }
    /**
     * 产品卡管理-详情
     * @return  mixed
    */
    public static function detail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail([]);
    }
    /**
     * 产品卡管理-创建实体卡-无需审批
     * @return  int
    */
    public static function createPhysical (\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ProductCardPhysicalCmd $productCardPhysicalCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPhysical($productCardPhysicalCmd);
    }
    /**
     * 产品卡管理-创建产品券
     * @return  bool
    */
    public static function createVirtual (\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ProductCardCmd $productCardCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createVirtual($productCardCmd);
    }
    /**
     * 优惠券管理-撤回审批
     * @return  bool
    */
    public static function cancelAudit (int $audit_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelAudit(["audit_id" => $audit_id]);
    }
    /**
     * 获取产品卡列表(分页)
     * @return  array
    */
    public static function codeList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->codeList([]);
    }
    /**
     * 获取产品卡列表(所有)
     * @return  array
    */
    public static function codeAll () {
        return RpcClass::getClass(self::$serviceName, self::$className)->codeAll([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}