<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-19 17:50:25
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Campaign;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Campaign
 * @method initCampaignByParams(array $params) 初始化活动
 * @method previewCampaignTemplateByParams(array $params) 保存预览模版
 * @method saveCampaignTemplateByParams(array $params) 保存模版
 * @method publishCampaignTemplateByParams(array $params) 发布模版
 * @method getCampaignDetailByParams(array $params) 获取活动模版详情
 * @method getCampaignListByParams(array $params) 承接页活动列表
 * @method updateCampaignStatusByParams(array $params) 承接页活动上下线
 * @method campaignDeleteByParams(array $params) 承接页活动删除
 */
class Campaign {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Campaign\\Campaign";

    /**
     * 初始化活动
     * @return  int
    */
    public static function initCampaign () {
        return RpcClass::getClass(self::$serviceName, self::$className)->initCampaign();
    }
    /**
     * 保存预览模版
     * @return  bool
    */
    public static function previewCampaignTemplate (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignPreviewCMD $campaignPreviewCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->previewCampaignTemplate($campaignPreviewCMD);
    }
    /**
     * 保存模版
     * @return  bool
    */
    public static function saveCampaignTemplate (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignSaveCMD $campaignSaveCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveCampaignTemplate($campaignSaveCMD);
    }
    /**
     * 发布模版
     * @return  bool
    */
    public static function publishCampaignTemplate (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignPublishCMD $campaignPublishCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->publishCampaignTemplate($campaignPublishCMD);
    }
    /**
     * 获取活动模版详情
     * @return  \Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignDTO
    */
    public static function getCampaignDetail (int $campaignId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCampaignDetail(["campaignId" => $campaignId]),
            "\Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignDTO"
        );
    }
    /**
     * 承接页活动列表
     * @return  \Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignListDTO
    */
    public static function getCampaignList (?\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignListCmd $campaignListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCampaignList($campaignListCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignListDTO"
        );
    }
    /**
     * 承接页活动上下线
     * @return  bool
    */
    public static function updateCampaignStatus (int $campaignId, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateCampaignStatus(["campaignId" => $campaignId, "status" => $status]);
    }
    /**
     * 承接页活动删除
     * @return  bool
    */
    public static function campaignDelete (int $campaignId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->campaignDelete(["campaignId" => $campaignId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}