<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-19 17:50:25
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class KfMessage
 * @method addByParams(array $params) 添加客服消息
 * @method updateByParams(array $params) 更新客服消息
 * @method setStatusByParams(array $params) 客服消息上下线
 * @method listByParams(array $params) 客服消息列表
 * @method infoByParams(array $params) 客服消息详情
 * @method upLoadImageByParams(array $params) 上传图片
 */
class KfMessage {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\KfMessage";

    /**
     * 添加客服消息
     * @return  mixed
    */
    public static function add (string $message_name, string $message_key, array $product_ids, int $delay_time, int $hit_product_num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->add(["message_name" => $message_name, "message_key" => $message_key, "product_ids" => $product_ids, "delay_time" => $delay_time, "hit_product_num" => $hit_product_num]);
    }
    /**
     * 更新客服消息
     * @return  mixed
    */
    public static function update (int $id, string $message_name, string $message_key, array $product_ids, int $delay_time, int $hit_product_num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "message_name" => $message_name, "message_key" => $message_key, "product_ids" => $product_ids, "delay_time" => $delay_time, "hit_product_num" => $hit_product_num]);
    }
    /**
     * 客服消息上下线
     * @return  mixed
    */
    public static function setStatus (int $id, int $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setStatus(["id" => $id, "status" => $status]);
    }
    /**
     * 客服消息列表
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }
    /**
     * 客服消息详情
     * @return  mixed
    */
    public static function info (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->info(["id" => $id]);
    }
    /**
     * 上传图片
     * @return  mixed
    */
    public static function upLoadImage () {
        return RpcClass::getClass(self::$serviceName, self::$className)->upLoadImage([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}