<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-22 18:55:21
 */
namespace Mainto\Bridge\Invokes\HimoProduct\SupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class RetailInventory
 * @method getInventoriesByParams(array $params) 获取盘点数据记录
 * @method getInventoryByParams(array $params) 获取盘点记录详情
 * @method newTaskByParams(array $params) 新增导出任务
 */
class RetailInventory {
    private static string $serviceName = "HimoProduct";

    private static string $className = "SupplyChain\\RetailInventory";

    /**
     * 获取盘点数据记录
     * @return  array
    */
    public static function getInventories () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInventories([]);
    }
    /**
     * 获取盘点记录详情
     * @return  array
    */
    public static function getInventory (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInventory(["id" => $id]);
    }
    /**
     * 新增导出任务
     * @return  string
    */
    public static function newTask (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->newTask(["template_id" => $template_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}