<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-19 16:20:58
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 * @method createByParams(array $params) 创建产品
 * @method detailByParams(array $params) 产品详情
 * @method deleteByParams(array $params) 删除产品
 * @method christmasActivitySettingByParams(array $params) 2020圣诞照配置
 * @method updateByParams(array $params) 更新产品
 * @method getProductListByParams(array $params) 产品列表
 * @method getAllProductByParams(array $params) 全部产品列表
 * @method upProductByParams(array $params) 上架产品
 * @method addServiceGroupByParams(array $params) 添加服务组
 * @method editServiceGroupByParams(array $params) 编辑升级服务组
 * @method downProductByParams(array $params) 下架产品
 * @method serviceGroupsByParams(array $params) 获取全部服务组
 * @method serviceLabelsByParams(array $params) 获取全部服务项
 * @method addServiceLabelByParams(array $params) 添加服务项
 * @method productDiscountCalcByParams(array $params) 产品全局折扣计算
 * @method editExtendByParams(array $params) 修改extend
 * @method editCHiddenByParams(array $params) 设置预约端显示
 * @method getProductTreeByModulesByParams(array $params) 根据MODULE获取类目/产品树
 * @method getCronUpDownTimeByParams(array $params) 获取产品定时上下线时间
 * @method setCronUpDownTimeByParams(array $params) 设置定时上下线时间
 * @method cronUpDownProductByParams(array $params) 定时上下线活动
 * @method addStoreToBlacklistByParams(array $params) 添加产品禁用门店
 * @method getProductBlacklistsByParams(array $params) 获取产品禁用门店
 * @method setAppointmentDeadlineByParams(array $params) 设置产品预约截止时间
 * @method dragProductByParams(array $params) 产品拖拽排序
 * @method getProductsOccupyByParams(array $params) 获取产品占点
 * @method copyProductByParams(array $params) 复制产品
 * @method clearCacheByParams(array $params) 清理产品缓存
 * @method editRecommendProductByParams(array $params) 编辑推荐产品
 * @method getRecommendProductByParams(array $params) 获取推荐产品/产品组
 * @method getServiceByIdsByParams(array $params) 批量获取服务
 * @method getGonggeAliasByParams(array $params) 获取全产品宫格别名
 * @method batchAddStoreToProductBlacklistByParams(array $params) 批量添加门店到产品黑名单
 * @method getBlackListsByStoreIdByParams(array $params) 根据门店获取产品黑名单详情
 * @method exportBlackListsByStoreIdByParams(array $params) 下载门店获取产品黑名单详情
 * @method getAllStoreBlackListCountByParams(array $params) 获取门店产品黑名单数量
 * @method getCityAndPriceAreaStoreInfosByBrandByParams(array $params) 根据品牌获取城市和价格区下的门店信息
 * @method getCityStoreInfosByStoreTypesByParams(array $params) 根据品牌获取城市下的门店信息
 * @method updateProductTagsByParams(array $params) 更新产品标签
 * @method getProductPriceAreaMinByCategoryIdByParams(array $params) 获取产品价格区间最小值通过产品分类id
 * @method getShowPicProductSkuListByParams(array $params) 得到修修兽产品sku下拉列表
 * @method getRetailProductsByParams(array $params) 获取产品类目下的所有可绑定零售
 * @method getProductServiceGroupTypeByParams(array $params) 获取产品服务组类型
 */
class Product {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Product";

    /**
     * 创建产品
     * @return  mixed
    */
    public static function create (string $module, string $name, int $category_id, string $main_img) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["module" => $module, "name" => $name, "category_id" => $category_id, "main_img" => $main_img]);
    }
    /**
     * 产品详情
     * @return  array
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 删除产品
     * @return  bool
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 2020圣诞照配置
     * @return  array
    */
    public static function christmasActivitySetting () {
        return RpcClass::getClass(self::$serviceName, self::$className)->christmasActivitySetting();
    }
    /**
     * 更新产品
     * @return  mixed
    */
    public static function update (int $id, string $module, string $name, int $category_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "module" => $module, "name" => $name, "category_id" => $category_id]);
    }
    /**
     * 产品列表
     * @return  mixed
    */
    public static function getProductList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductList([]);
    }
    /**
     * 全部产品列表
     * @return  mixed
    */
    public static function getAllProduct () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProduct([]);
    }
    /**
     * 上架产品
     * @return  mixed
    */
    public static function upProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->upProduct(["id" => $id]);
    }
    /**
     * 添加服务组
     * @return  mixed
    */
    public static function addServiceGroup (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addServiceGroup(["name" => $name]);
    }
    /**
     * 编辑升级服务组
     * @return  mixed
    */
    public static function editServiceGroup (int $id, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editServiceGroup(["id" => $id, "name" => $name]);
    }
    /**
     * 下架产品
     * @return  mixed
    */
    public static function downProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->downProduct(["id" => $id]);
    }
    /**
     * 获取全部服务组
     * @return  mixed
    */
    public static function serviceGroups () {
        return RpcClass::getClass(self::$serviceName, self::$className)->serviceGroups();
    }
    /**
     * 获取全部服务项
     * @return  mixed
    */
    public static function serviceLabels () {
        return RpcClass::getClass(self::$serviceName, self::$className)->serviceLabels();
    }
    /**
     * 添加服务项
     * @return  mixed
    */
    public static function addServiceLabel (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addServiceLabel(["name" => $name]);
    }
    /**
     * 产品全局折扣计算
     * @return  mixed
    */
    public static function productDiscountCalc (int $store_id, array $product_num_map) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productDiscountCalc(["store_id" => $store_id, "product_num_map" => $product_num_map]);
    }
    /**
     * 修改extend
     * @return  mixed
    */
    public static function editExtend () {
        return RpcClass::getClass(self::$serviceName, self::$className)->editExtend([]);
    }
    /**
     * 设置预约端显示
     * @return  mixed
    */
    public static function editCHidden () {
        return RpcClass::getClass(self::$serviceName, self::$className)->editCHidden([]);
    }
    /**
     * 根据MODULE获取类目/产品树
     * @return  mixed
    */
    public static function getProductTreeByModules () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductTreeByModules([]);
    }
    /**
     * 获取产品定时上下线时间
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Product\DTO\CronUpDownTimeDTO
    */
    public static function getCronUpDownTime (int $product_id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCronUpDownTime(["product_id" => $product_id]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Product\DTO\CronUpDownTimeDTO"
        );
    }
    /**
     * 设置定时上下线时间
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Product\DTO\CronUpDownTimeDTO
    */
    public static function setCronUpDownTime (int $product_id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->setCronUpDownTime(["product_id" => $product_id]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Product\DTO\CronUpDownTimeDTO"
        );
    }
    /**
     * 定时上下线活动
     * @return  void
    */
    public static function cronUpDownProduct () {
         RpcClass::getClass(self::$serviceName, self::$className)->cronUpDownProduct();
    }
    /**
     * 添加产品禁用门店
     * @return  bool
    */
    public static function addStoreToBlacklist (int $product_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addStoreToBlacklist(["product_id" => $product_id]);
    }
    /**
     * 获取产品禁用门店
     * @return  mixed
    */
    public static function getProductBlacklists (int $product_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductBlacklists(["product_id" => $product_id]);
    }
    /**
     * 设置产品预约截止时间
     * @return  mixed
    */
    public static function setAppointmentDeadline (int $product_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setAppointmentDeadline(["product_id" => $product_id]);
    }
    /**
     * 产品拖拽排序
     * @return  bool
    */
    public static function dragProduct (int $current_id, int $target_parent_id, int $target_sort) {
        return RpcClass::getClass(self::$serviceName, self::$className)->dragProduct(["current_id" => $current_id, "target_parent_id" => $target_parent_id, "target_sort" => $target_sort]);
    }
    /**
     * 获取产品占点
     * @return  int
    */
    public static function getProductsOccupy (array $product_group) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsOccupy(["product_group" => $product_group]);
    }
    /**
     * 复制产品
     * @return  mixed
    */
    public static function copyProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->copyProduct(["id" => $id]);
    }
    /**
     * 清理产品缓存
     * @return  bool
    */
    public static function clearCache () {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearCache();
    }
    /**
     * 编辑推荐产品
     * @return  mixed
    */
    public static function editRecommendProduct (int $category_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editRecommendProduct(["category_id" => $category_id]);
    }
    /**
     * 获取推荐产品/产品组
     * @return  mixed
    */
    public static function getRecommendProduct (int $category_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRecommendProduct(["category_id" => $category_id]);
    }
    /**
     * 批量获取服务
     * @return  mixed
    */
    public static function getServiceByIds (array $service_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServiceByIds(["service_ids" => $service_ids]);
    }
    /**
     * 获取全产品宫格别名
     * @return  mixed
    */
    public static function getGonggeAlias () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGonggeAlias();
    }
    /**
     * 批量添加门店到产品黑名单
     * @return  bool
    */
    public static function batchAddStoreToProductBlacklist (array $storeIds, string $blacklistHandleType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchAddStoreToProductBlacklist(["storeIds" => $storeIds, "blacklistHandleType" => $blacklistHandleType]);
    }
    /**
     * 根据门店获取产品黑名单详情
     * @return  mixed
    */
    public static function getBlackListsByStoreId (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBlackListsByStoreId(["storeId" => $storeId]);
    }
    /**
     * 下载门店获取产品黑名单详情
     * @return  mixed
    */
    public static function exportBlackListsByStoreId (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportBlackListsByStoreId(["storeId" => $storeId]);
    }
    /**
     * 获取门店产品黑名单数量
     * @return  array
    */
    public static function getAllStoreBlackListCount () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAllStoreBlackListCount(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Product\DTO\StoreBlackDTO[]"
        );
    }
    /**
     * 根据品牌获取城市和价格区下的门店信息
     * @return  mixed
    */
    public static function getCityAndPriceAreaStoreInfosByBrand (string $module, string $store_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCityAndPriceAreaStoreInfosByBrand(["module" => $module, "store_type" => $store_type]);
    }
    /**
     * 根据品牌获取城市下的门店信息
     * @return  array
    */
    public static function getCityStoreInfosByStoreTypes () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCityStoreInfosByStoreTypes([]);
    }
    /**
     * 更新产品标签
     * @return  bool
    */
    public static function updateProductTags (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateProductTags(["productId" => $productId]);
    }
    /**
     * 获取产品价格区间最小值通过产品分类id
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Product\DTO\ProductPriceAreaMinDTO
    */
    public static function getProductPriceAreaMinByCategoryId (int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProductPriceAreaMinByCategoryId(["categoryId" => $categoryId]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Product\DTO\ProductPriceAreaMinDTO"
        );
    }
    /**
     * 得到修修兽产品sku下拉列表
     * @return  array
    */
    public static function getShowPicProductSkuList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShowPicProductSkuList(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Product\DTO\ShowPicProductSelectDTO[]"
        );
    }
    /**
     * 获取产品类目下的所有可绑定零售
     * @return  array
    */
    public static function getRetailProducts (int $categoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetailProducts(["categoryId" => $categoryId]);
    }
    /**
     * 获取产品服务组类型
     * @return  array
    */
    public static function getProductServiceGroupType () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductServiceGroupType();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}