<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-19 16:20:58
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OrderRefund
 * @method listByParams(array $params) 退款列表
 * @method calcRefundInfoByOrderItemsByParams(array $params) 根据订单的拍摄产品获取可退信息
 * @method createV2ByParams(array $params) 退款申请v2
 * @method confirmV2ByParams(array $params) 退款处理V2
 * @method createAndConfirmV2ByParams(array $params) 退款申请并退款v2
 * @method createSpecialRefundAndConfirmByParams(array $params) 创建特殊部分退款申请并处理
 * @method fixDubiousRefundResultByParams(array $params) 对待确认的错误退款进行修正
 * @method fixRefundAccountByParams(array $params) 修改信息
 * @method detailByParams(array $params) 退款详情
 * @method doubtSuccessByParams(array $params) 存疑自动退款-改为已退
 * @method doubtErrorByParams(array $params) 存疑自动退款-改为未退
 * @method doubtErrorToSuccessByParams(array $params) 存疑自动退款未退订单-改为已退
 * @method manualSuccessByParams(array $params) 手动退款订单-标记为已处理
 * @method refuseByParams(array $params) 拒绝退款
 * @method reasonByParams(array $params) 退款理由
 * @method confirmHandRefundByParams(array $params) 手动退款再次确认
 * @method getOrderRefundInfoByParams(array $params) 获取订单退款信息
 * @method afterRefundForPlatformByParams(array $params) 接收预约端退款消息
 * @method setRefundExtendByParams(array $params) 设置退款扩展信息
 * @method retryAutoRefundByParams(array $params) 自动退款失败进行重试
 */
class OrderRefund {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\OrderRefund";

    /**
     * 退款列表
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }
    /**
     * 根据订单的拍摄产品获取可退信息
     * @return  mixed
    */
    public static function calcRefundInfoByOrderItems (int $orderId, array $refundInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calcRefundInfoByOrderItems(["orderId" => $orderId, "refundInfo" => $refundInfo]);
    }
    /**
     * 退款申请v2
     * @return  mixed
    */
    public static function createV2 (int $orderId, int $scale, string $people, string $account, array $reasonIds, array $refundInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createV2(["orderId" => $orderId, "scale" => $scale, "people" => $people, "account" => $account, "reasonIds" => $reasonIds, "refundInfo" => $refundInfo]);
    }
    /**
     * 退款处理V2
     * @return  mixed
    */
    public static function confirmV2 (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmV2(["id" => $id]);
    }
    /**
     * 退款申请并退款v2
     * @return  mixed
    */
    public static function createAndConfirmV2 (int $orderId, string $people, string $account, array $reasonIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createAndConfirmV2(["orderId" => $orderId, "people" => $people, "account" => $account, "reasonIds" => $reasonIds]);
    }
    /**
     * 创建特殊部分退款申请并处理
     * @return  mixed
    */
    public static function createSpecialRefundAndConfirm (int $orderId, string $refundType, string $refundMoneyType = 'normal', float $refundMoney, string $people, string $account, array $reasonIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSpecialRefundAndConfirm(["orderId" => $orderId, "refundType" => $refundType, "refundMoneyType" => $refundMoneyType, "refundMoney" => $refundMoney, "people" => $people, "account" => $account, "reasonIds" => $reasonIds]);
    }
    /**
     * 对待确认的错误退款进行修正
     * @return  array
    */
    public static function fixDubiousRefundResult (int $id, float $auto_real_money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixDubiousRefundResult(["id" => $id, "auto_real_money" => $auto_real_money]);
    }
    /**
     * 修改信息
     * @return  mixed
    */
    public static function fixRefundAccount (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixRefundAccount(["id" => $id]);
    }
    /**
     * 退款详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 存疑自动退款-改为已退
     * @return  mixed
    */
    public static function doubtSuccess (int $refundId, int $refundMoneyDetailId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->doubtSuccess(["refundId" => $refundId, "refundMoneyDetailId" => $refundMoneyDetailId]);
    }
    /**
     * 存疑自动退款-改为未退
     * @return  mixed
    */
    public static function doubtError (int $refundId, int $refundMoneyDetailId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->doubtError(["refundId" => $refundId, "refundMoneyDetailId" => $refundMoneyDetailId]);
    }
    /**
     * 存疑自动退款未退订单-改为已退
     * @return  mixed
    */
    public static function doubtErrorToSuccess (int $refundId, int $refundMoneyDetailId, string $paymentNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->doubtErrorToSuccess(["refundId" => $refundId, "refundMoneyDetailId" => $refundMoneyDetailId, "paymentNo" => $paymentNo]);
    }
    /**
     * 手动退款订单-标记为已处理
     * @return  mixed
    */
    public static function manualSuccess (int $refundId, int $refundMoneyDetailId, string $paymentNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->manualSuccess(["refundId" => $refundId, "refundMoneyDetailId" => $refundMoneyDetailId, "paymentNo" => $paymentNo]);
    }
    /**
     * 拒绝退款
     * @return  mixed
    */
    public static function refuse () {
        return RpcClass::getClass(self::$serviceName, self::$className)->refuse([]);
    }
    /**
     * 退款理由
     * @return  mixed
    */
    public static function reason () {
        return RpcClass::getClass(self::$serviceName, self::$className)->reason([]);
    }
    /**
     * 手动退款再次确认
     * @return  mixed
    */
    public static function confirmHandRefund (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmHandRefund(["id" => $id]);
    }
    /**
     * 获取订单退款信息
     * @return  mixed
    */
    public static function getOrderRefundInfo (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderRefundInfo(["order_no" => $order_no]);
    }
    /**
     * 接收预约端退款消息
     * @return  bool
    */
    public static function afterRefundForPlatform (int $refundId, float $oldRefundMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterRefundForPlatform(["refundId" => $refundId, "oldRefundMoney" => $oldRefundMoney]);
    }
    /**
     * 设置退款扩展信息
     * @return  bool
    */
    public static function setRefundExtend (\Mainto\Bridge\Structs\HimoProduct\Admin\OrderRefund\Cmd\SetRefundExtendCmd $setRefundExtendCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setRefundExtend($setRefundExtendCmd);
    }
    /**
     * 自动退款失败进行重试
     * @return  bool
    */
    public static function retryAutoRefund (\Mainto\Bridge\Structs\HimoProduct\Admin\OrderRefund\Cmd\RetryAutoRefundCmd $retryAutoRefundCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->retryAutoRefund($retryAutoRefundCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}