<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-19 16:20:58
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ChartLet
 * @method addChartLetByParams(array $params) 添加贴图
 * @method chartLetListByParams(array $params) 贴图素材列表
 * @method updateChartLetByParams(array $params) 编辑贴图
 * @method changeStatusByParams(array $params) 更改素材状态
 * @method deletedByParams(array $params) 删除贴图素材
 * @method infoByParams(array $params) 素材详情
 * @method tagSelectByParams(array $params) 标签下拉
 */
class ChartLet {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\ChartLet";

    /**
     * 添加贴图
     * @return  bool
    */
    public static function addChartLet () {
        return RpcClass::getClass(self::$serviceName, self::$className)->addChartLet([]);
    }
    /**
     * 贴图素材列表
     * @return  mixed
    */
    public static function chartLetList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->chartLetList([]);
    }
    /**
     * 编辑贴图
     * @return  bool
    */
    public static function updateChartLet (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateChartLet(["id" => $id]);
    }
    /**
     * 更改素材状态
     * @return  bool
    */
    public static function changeStatus (int $materialId, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeStatus(["materialId" => $materialId, "status" => $status]);
    }
    /**
     * 删除贴图素材
     * @return  bool
    */
    public static function deleted () {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleted([]);
    }
    /**
     * 素材详情
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\ChartLet\Dto\MaterialDto
    */
    public static function info () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->info([]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\ChartLet\Dto\MaterialDto"
        );
    }
    /**
     * 标签下拉
     * @return  array
    */
    public static function tagSelect () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->tagSelect(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\ChartLet\Dto\PictureTagDto[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}