<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-21 11:48:58
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class CustomerPhoto
 * @method listByParams(array $params) 客片已授权列表
 * @method orderListByParams(array $params) 待授权列表
 * @method sendNoticeByParams(array $params) 发送授权确认推送
 * @method detailByParams(array $params) 授权详情
 * @method cancelByParams(array $params) 取消授权
 * @method getCustomerPhotoAuthStatusByParams(array $params) 获取授权信息(RPC调用 用于看片师授权)
 * @method resetPhotoAuthByParams(array $params) 重置授权信息(RPC调用 用于看片师授权)
 */
class CustomerPhoto {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\CustomerPhoto";

    /**
     * 客片已授权列表
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }
    /**
     * 待授权列表
     * @return  mixed
    */
    public static function orderList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderList([]);
    }
    /**
     * 发送授权确认推送
     * @return  mixed
    */
    public static function sendNotice (string $order_num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendNotice(["order_num" => $order_num]);
    }
    /**
     * 授权详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 取消授权
     * @return  mixed
    */
    public static function cancel (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["id" => $id]);
    }
    /**
     * 获取授权信息(RPC调用 用于看片师授权)
     * @return  mixed
    */
    public static function getCustomerPhotoAuthStatus (string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCustomerPhotoAuthStatus(["orderNum" => $orderNum]);
    }
    /**
     * 重置授权信息(RPC调用 用于看片师授权)
     * @return  mixed
    */
    public static function resetPhotoAuth (string $orderNum, int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resetPhotoAuth(["orderNum" => $orderNum, "staffId" => $staffId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}