<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-21 10:27:41
 */
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class DouyinMerchant
 * @method getDouyinMerchantListByParams(array $params) 抖音进件列表
 * @method addDouyinMerchantByParams(array $params) 抖音-新增进件
 * @method getDouyinMerchantDetailByParams(array $params) 抖音-进件详情
 * @method checkDouyinPermissionByParams(array $params) 抖音-用户校验更新权限
 * @method getBindStoresByMerchantIdByParams(array $params) 抖音-根据merchantId获取绑定门店数据
 * @method batchBindStoresByParams(array $params) 抖音-商户批量绑定/解绑门店
 */
class DouyinMerchant {
    private static string $serviceName = "HimoProduct";

    private static string $className = "User\\DouyinMerchant";

    /**
     * 抖音进件列表
     * @return  \Mainto\Bridge\Structs\HimoProduct\User\DTO\DouyinMerchant\DouyinMerchantListDTO
    */
    public static function getDouyinMerchantList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDouyinMerchantList([]),
            "\Mainto\Bridge\Structs\HimoProduct\User\DTO\DouyinMerchant\DouyinMerchantListDTO"
        );
    }
    /**
     * 抖音-新增进件
     * @return  \Mainto\Bridge\Structs\HimoProduct\User\DTO\DouyinMerchant\DouyinMerchantInfoDTO
    */
    public static function addDouyinMerchant (int $staffId, string $name) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->addDouyinMerchant(["staffId" => $staffId, "name" => $name]),
            "\Mainto\Bridge\Structs\HimoProduct\User\DTO\DouyinMerchant\DouyinMerchantInfoDTO"
        );
    }
    /**
     * 抖音-进件详情
     * @return  \Mainto\Bridge\Structs\HimoProduct\User\DTO\DouyinMerchant\DouyinMerchantInfoDTO
    */
    public static function getDouyinMerchantDetail (int $staffId, string $merchantId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDouyinMerchantDetail(["staffId" => $staffId, "merchantId" => $merchantId]),
            "\Mainto\Bridge\Structs\HimoProduct\User\DTO\DouyinMerchant\DouyinMerchantInfoDTO"
        );
    }
    /**
     * 抖音-用户校验更新权限
     * @return  bool
    */
    public static function checkDouyinPermission () {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkDouyinPermission();
    }
    /**
     * 抖音-根据merchantId获取绑定门店数据
     * @return  \Mainto\Bridge\Structs\HimoProduct\User\DTO\DouyinMerchant\DouyinMerchantBindStoreInfoDTO
    */
    public static function getBindStoresByMerchantId (int $merchantId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBindStoresByMerchantId(["merchantId" => $merchantId]),
            "\Mainto\Bridge\Structs\HimoProduct\User\DTO\DouyinMerchant\DouyinMerchantBindStoreInfoDTO"
        );
    }
    /**
     * 抖音-商户批量绑定/解绑门店
     * @return  bool
    */
    public static function batchBindStores (int $merchantId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchBindStores(["merchantId" => $merchantId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}