<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-20 15:05:33
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Subcompany
 * @method addByParams(array $params) 新增子公司
 * @method listByParams(array $params) 查询子公司(带分页)
 * @method allByParams(array $params) 查询子公司(不带分页)
 * @method editByParams(array $params) 编辑子公司
 * @method deleteByParams(array $params) 删除子公司
 */
class Subcompany {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Subcompany";

    /**
     * 新增子公司
     * @return  mixed
    */
    public static function add () {
        return RpcClass::getClass(self::$serviceName, self::$className)->add([]);
    }
    /**
     * 查询子公司(带分页)
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }
    /**
     * 查询子公司(不带分页)
     * @return  mixed
    */
    public static function all () {
        return RpcClass::getClass(self::$serviceName, self::$className)->all([]);
    }
    /**
     * 编辑子公司
     * @return  mixed
    */
    public static function edit (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->edit(["id" => $id]);
    }
    /**
     * 删除子公司
     * @return  bool
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}