<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-22 22:30:55
 */
namespace Mainto\Bridge\Invokes\HimoProduct\BuyerShow;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class BuyerShow
 * @method buyerShowListByParams(array $params) 买家秀列表
 * @method buyerShowDetailByParams(array $params) 买家秀详情
 * @method createBuyerShowByParams(array $params) 创建买家秀
 * @method updateBuyerShowByParams(array $params) 更新买家秀
 * @method updateBuyerShowSimpleByParams(array $params) 更新买家秀 - 简易
 * @method buyerShowOrderInfoByParams(array $params) 订单卖家秀信息
 * @method sendInviteByParams(array $params) 发送邀请
 * @method deleteBuyerShowByParams(array $params) 删除买家秀
 * @method auditPassByParams(array $params) 审核通过
 * @method auditRejectByParams(array $params) 审核拒绝
 * @method setStarByParams(array $params) 设为精选|上架
 * @method cancelStarByParams(array $params) 取消精选|下架
 * @method setAfterSaleByParams(array $params) 转接售后
 */
class BuyerShow {
    private static string $serviceName = "HimoProduct";

    private static string $className = "BuyerShow\\BuyerShow";

    /**
     * 买家秀列表
     * @return  \Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\BuyerShowListDTO
    */
    public static function buyerShowList (\Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\BuyerShowListCmd $buyerShowListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->buyerShowList($buyerShowListCmd),
            "\Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\BuyerShowListDTO"
        );
    }
    /**
     * 买家秀详情
     * @return  \Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\BuyerShowDTO
    */
    public static function buyerShowDetail () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->buyerShowDetail([]),
            "\Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\BuyerShowDTO"
        );
    }
    /**
     * 创建买家秀
     * @return  int
    */
    public static function createBuyerShow (\Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\CreateBuyerShowCmd $createBuyerShowCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createBuyerShow($createBuyerShowCmd);
    }
    /**
     * 更新买家秀
     * @return  bool
    */
    public static function updateBuyerShow (\Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\UpdateBuyerShowCmd $updateBuyerShowCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateBuyerShow($updateBuyerShowCmd);
    }
    /**
     * 更新买家秀 - 简易
     * @return  bool
    */
    public static function updateBuyerShowSimple (\Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\UpdateBuyerShowSimpleCmd $updateBuyerShowSimpleCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateBuyerShowSimple($updateBuyerShowSimpleCmd);
    }
    /**
     * 订单卖家秀信息
     * @return  \Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\BuyerShowOrderDTO
    */
    public static function buyerShowOrderInfo (string $orderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->buyerShowOrderInfo(["orderNum" => $orderNum]),
            "\Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\BuyerShowOrderDTO"
        );
    }
    /**
     * 发送邀请
     * @return  \Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\SendMessageResDTO
    */
    public static function sendInvite (string $orderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->sendInvite(["orderNum" => $orderNum]),
            "\Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\SendMessageResDTO"
        );
    }
    /**
     * 删除买家秀
     * @return  bool
    */
    public static function deleteBuyerShow (int $shareOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteBuyerShow(["shareOrderId" => $shareOrderId]);
    }
    /**
     * 审核通过
     * @return  bool
    */
    public static function auditPass (int $shareOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->auditPass(["shareOrderId" => $shareOrderId]);
    }
    /**
     * 审核拒绝
     * @return  bool
    */
    public static function auditReject (int $shareOrderId, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->auditReject(["shareOrderId" => $shareOrderId, "reason" => $reason]);
    }
    /**
     * 设为精选|上架
     * @return  bool
    */
    public static function setStar (int $shareOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setStar(["shareOrderId" => $shareOrderId]);
    }
    /**
     * 取消精选|下架
     * @return  bool
    */
    public static function cancelStar (int $shareOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelStar(["shareOrderId" => $shareOrderId]);
    }
    /**
     * 转接售后
     * @return  bool
    */
    public static function setAfterSale (int $shareOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setAfterSale(["shareOrderId" => $shareOrderId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}