<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-12 09:53:14
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Extend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ZhiChi
 * @method refreshTokenByParams(array $params) 定时刷新token
 * @method createTicketByParams(array $params) 创建工单
 * @method addTicketEvaluationByParams(array $params) 提交工单满意度
 * @method ticketCallbackByParams(array $params) 工单消息回调
 * @method getSatisfactionLevelLabelsByParams(array $params) 获取满意度的标签
 * @method createSatisfactionByParams(array $params) 创建满意度工单
 */
class ZhiChi {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Extend\\ZhiChi";

    /**
     * 定时刷新token
     * @return  mixed
    */
    public static function refreshToken () {
        return RpcClass::getClass(self::$serviceName, self::$className)->refreshToken();
    }
    /**
     * 创建工单
     * @return  mixed
    */
    public static function createTicket (int $share_order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createTicket(["share_order_id" => $share_order_id]);
    }
    /**
     * 提交工单满意度
     * @return  bool
    */
    public static function addTicketEvaluation (string $ticket_id, int $score, string $feeling, int $willing) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addTicketEvaluation(["ticket_id" => $ticket_id, "score" => $score, "feeling" => $feeling, "willing" => $willing]);
    }
    /**
     * 工单消息回调
     * @return  string
    */
    public static function ticketCallback (string $sys_code, string $type, array $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->ticketCallback(["sys_code" => $sys_code, "type" => $type, "content" => $content]);
    }
    /**
     * 获取满意度的标签
     * @return  array
    */
    public static function getSatisfactionLevelLabels () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSatisfactionLevelLabels();
    }
    /**
     * 创建满意度工单
     * @return  bool
    */
    public static function createSatisfaction (string $ticket_source, string $ticket_code, string $user_phone, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSatisfaction(["ticket_source" => $ticket_source, "ticket_code" => $ticket_code, "user_phone" => $user_phone, "extend" => $extend]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}