<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-22 11:32:16
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Tmp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class JiGuangActivity
 * @method getQuestionByParams(array $params) 获取问题
 * @method getMedalNumByParams(array $params) 获取奖章数
 * @method answerQuestionByParams(array $params) 回答问题
 * @method drawAwardByParams(array $params) 抽奖
 * @method sendNoticeOneByParams(array $params) 每周五推送极光之星活动消息
 * @method sendNoticeTwoByParams(array $params) 每周五推送极光之星活动消息
 * @method sendNoticeThreeByParams(array $params) 每周五推送极光之星活动消息
 * @method sendNoticeFourByParams(array $params) 手动执行发送消息，防止上线后没收到链接
 * @method addMedalNumByParams(array $params) 手动执行爆款项目增加奖章数
 * @method importAnswerByParams(array $params) 导入答案
 * @method importMyGuessByParams(array $params) 导入我猜
 */
class JiGuangActivity {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Tmp\\JiGuangActivity";

    /**
     * 获取问题
     * @return  mixed
    */
    public static function getQuestion (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getQuestion(["staffId" => $staffId]);
    }
    /**
     * 获取奖章数
     * @return  mixed
    */
    public static function getMedalNum (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMedalNum(["staffId" => $staffId]);
    }
    /**
     * 回答问题
     * @return  mixed
    */
    public static function answerQuestion (int $staffId, string $answer, int $key) {
        return RpcClass::getClass(self::$serviceName, self::$className)->answerQuestion(["staffId" => $staffId, "answer" => $answer, "key" => $key]);
    }
    /**
     * 抽奖
     * @return  mixed
    */
    public static function drawAward (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->drawAward(["staffId" => $staffId]);
    }
    /**
     * 每周五推送极光之星活动消息
     * @return  mixed
    */
    public static function sendNoticeOne () {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendNoticeOne();
    }
    /**
     * 每周五推送极光之星活动消息
     * @return  mixed
    */
    public static function sendNoticeTwo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendNoticeTwo();
    }
    /**
     * 每周五推送极光之星活动消息
     * @return  mixed
    */
    public static function sendNoticeThree () {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendNoticeThree();
    }
    /**
     * 手动执行发送消息，防止上线后没收到链接
     * @return  bool
    */
    public static function sendNoticeFour () {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendNoticeFour([]);
    }
    /**
     * 手动执行爆款项目增加奖章数
     * @return  bool
    */
    public static function addMedalNum (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addMedalNum(["id" => $id]);
    }
    /**
     * 导入答案
     * @return  bool
    */
    public static function importAnswer (string $name, string $imgPath, int $peopleCount) {
        return RpcClass::getClass(self::$serviceName, self::$className)->importAnswer(["name" => $name, "imgPath" => $imgPath, "peopleCount" => $peopleCount]);
    }
    /**
     * 导入我猜
     * @return  bool
    */
    public static function importMyGuess (string $name, string $imgPath, array $staffIds, string $date) {
        return RpcClass::getClass(self::$serviceName, self::$className)->importMyGuess(["name" => $name, "imgPath" => $imgPath, "staffIds" => $staffIds, "date" => $date]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}