<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-02 11:17:59
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Category
 * @method createByParams(array $params) 创建类目
 * @method detailByParams(array $params) 产品类目详情
 * @method deleteByParams(array $params) 删除产品类目
 * @method updateByParams(array $params) 更新类目
 * @method updateStatusByParams(array $params) 更改类目状态
 * @method getCategoryChildByParams(array $params) 获取类目所有子集
 * @method getProductCategoryListByParams(array $params) 类目列表
 * @method getProductCategoryAllByParams(array $params) 类目列表
 * @method editExtendByParams(array $params) 修改extend
 * @method getCategoryTreeByParams(array $params) 获取树状类目
 * @method setCHiddenStatusByParams(array $params) 开启/关闭该类目下产品预约端是否显示
 * @method dragCategoryByParams(array $params) 类目拖拽排序
 * @method allClothByParams(array $params) 获取某产品组所有服装
 * @method createClothByParams(array $params) 产品组添加服装
 * @method updateClothByParams(array $params) 更新服装
 * @method deleteClothByParams(array $params) 删除服装
 */
class Category {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Category";

    /**
     * 创建类目
     * @return  mixed
    */
    public static function create (string $name, string $module) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "module" => $module]);
    }
    /**
     * 产品类目详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 删除产品类目
     * @return  bool
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 更新类目
     * @return  mixed
    */
    public static function update (int $id, string $module, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "module" => $module, "name" => $name]);
    }
    /**
     * 更改类目状态
     * @return  mixed
    */
    public static function updateStatus (int $id, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStatus(["id" => $id, "status" => $status]);
    }
    /**
     * 获取类目所有子集
     * @return  mixed
    */
    public static function getCategoryChild (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryChild(["id" => $id]);
    }
    /**
     * 类目列表
     * @return  mixed
    */
    public static function getProductCategoryList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCategoryList([]);
    }
    /**
     * 类目列表
     * @return  mixed
    */
    public static function getProductCategoryAll () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCategoryAll([]);
    }
    /**
     * 修改extend
     * @return  mixed
    */
    public static function editExtend () {
        return RpcClass::getClass(self::$serviceName, self::$className)->editExtend([]);
    }
    /**
     * 获取树状类目
     * @return  mixed
    */
    public static function getCategoryTree () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryTree([]);
    }
    /**
     * 开启/关闭该类目下产品预约端是否显示
     * @return  bool
    */
    public static function setCHiddenStatus (int $id, bool $c_hidden) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setCHiddenStatus(["id" => $id, "c_hidden" => $c_hidden]);
    }
    /**
     * 类目拖拽排序
     * @return  bool
    */
    public static function dragCategory (int $current_id, int $target_parent_id, int $target_sort) {
        return RpcClass::getClass(self::$serviceName, self::$className)->dragCategory(["current_id" => $current_id, "target_parent_id" => $target_parent_id, "target_sort" => $target_sort]);
    }
    /**
     * 获取某产品组所有服装
     * @return  mixed
    */
    public static function allCloth (int $category_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->allCloth(["category_id" => $category_id]);
    }
    /**
     * 产品组添加服装
     * @return  mixed
    */
    public static function createCloth (int $category_id, string $gender, string $image) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createCloth(["category_id" => $category_id, "gender" => $gender, "image" => $image]);
    }
    /**
     * 更新服装
     * @return  mixed
    */
    public static function updateCloth (int $cloth_id, int $sort) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateCloth(["cloth_id" => $cloth_id, "sort" => $sort]);
    }
    /**
     * 删除服装
     * @return  bool
    */
    public static function deleteCloth (int $cloth_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteCloth(["cloth_id" => $cloth_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}