<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-07 17:22:52
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SamplePhoto
 * @method createByParams(array $params) 创建样片
 * @method listByParams(array $params) 获取样片列表
 * @method detailByParams(array $params) 获取样片详情
 * @method passByParams(array $params) 审核通过
 * @method deleteByParams(array $params) 移除客片
 * @method offShelfByParams(array $params) 下架样片
 * @method onShelfByParams(array $params) 上架样片
 * @method downloadByParams(array $params) 下载样片
 * @method orderPhotoByParams(array $params) 订单客片
 */
class SamplePhoto {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\SamplePhoto";

    /**
     * 创建样片
     * @return  bool
    */
    public static function create (string $brand, array $label, string $type, string $name, string $expired_at, array $images, string $evidence) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["brand" => $brand, "label" => $label, "type" => $type, "name" => $name, "expired_at" => $expired_at, "images" => $images, "evidence" => $evidence]);
    }
    /**
     * 获取样片列表
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }
    /**
     * 获取样片详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 审核通过
     * @return  bool
    */
    public static function pass (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pass(["id" => $id]);
    }
    /**
     * 移除客片
     * @return  bool
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 下架样片
     * @return  bool
    */
    public static function offShelf (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->offShelf(["id" => $id]);
    }
    /**
     * 上架样片
     * @return  bool
    */
    public static function onShelf (int $id, string $expired_at, string $evidence) {
        return RpcClass::getClass(self::$serviceName, self::$className)->onShelf(["id" => $id, "expired_at" => $expired_at, "evidence" => $evidence]);
    }
    /**
     * 下载样片
     * @return  bool
    */
    public static function download (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->download(["id" => $id]);
    }
    /**
     * 订单客片
     * @return  mixed
    */
    public static function orderPhoto (string $order_num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderPhoto(["order_num" => $order_num]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}