<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-07 17:22:52
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class CheckPool
 * @method extractByParams(array $params) 抽片
 * @method getProgressByParams(array $params) 获取抽片进度
 * @method getAllProductByBrandByParams(array $params) 通过品牌获取所有产品
 * @method getTodayEvaluateCountByParams(array $params) 今日已评单量
 * @method getExtractListByParams(array $params) 获取抽片列表
 * @method notDealWithTheItemByParams(array $params) 不处理此项
 * @method changeItemByParams(array $params) 换一单
 * @method preCommitScoreByParams(array $params) 预评分
 * @method getPreScoreListByParams(array $params) 获取预评分列表
 * @method confirmByParams(array $params) 最终确认
 * @method preCheckUpdateConfigByParams(array $params) 预检查是否可以更新配置
 * @method lockUpdateConfigByParams(array $params) 锁配置
 * @method unlockUpdateConfigByParams(array $params) 解锁配置
 * @method getScoreConfigByParams(array $params) 获取评分配置
 * @method updateScoreConfigByParams(array $params) 评分配置调整
 * @method queryRecordHistoryByParams(array $params) 查询评分历史记录
 * @method queryQualityReportByParams(array $params) 查询质量报告
 * @method queryHistoryAggregateByParams(array $params) 查询聚合数据
 * @method getStoreIdsByStaffByParams(array $params) 通过伙伴获取有权限的门店信息
 * @method getStaffByParams(array $params) 获取伙伴(根据入职时间)
 * @method getStreamInfoByParams(array $params) 获取流水信息
 * @method cronSubmitFinalCommitByParams(array $params) 定时任务提交最终评分
 * @method delScoreByParams(array $params) 删除评分
 * @method getPhotoProblemTagSetsByParams(array $params) 获取摄影化妆问题标签
 */
class CheckPool {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\CheckPool";

    /**
     * 抽片
     * @return  mixed
    */
    public static function extract (string $poolType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->extract(["poolType" => $poolType]);
    }
    /**
     * 获取抽片进度
     * @return  float
    */
    public static function getProgress (string $poolType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProgress(["poolType" => $poolType]);
    }
    /**
     * 通过品牌获取所有产品
     * @return  mixed
    */
    public static function getAllProductByBrand () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProductByBrand([]);
    }
    /**
     * 今日已评单量
     * @return  int
    */
    public static function getTodayEvaluateCount (string $poolType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTodayEvaluateCount(["poolType" => $poolType]);
    }
    /**
     * 获取抽片列表
     * @return  mixed
    */
    public static function getExtractList (string $poolType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExtractList(["poolType" => $poolType]);
    }
    /**
     * 不处理此项
     * @return  mixed
    */
    public static function notDealWithTheItem (string $poolType, string $itemId, int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->notDealWithTheItem(["poolType" => $poolType, "itemId" => $itemId, "staffId" => $staffId]);
    }
    /**
     * 换一单
     * @return  mixed
    */
    public static function changeItem (string $poolType, string $itemId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeItem(["poolType" => $poolType, "itemId" => $itemId]);
    }
    /**
     * 预评分
     * @return  mixed
    */
    public static function preCommitScore (string $poolType, string $itemId, array $score) {
        return RpcClass::getClass(self::$serviceName, self::$className)->preCommitScore(["poolType" => $poolType, "itemId" => $itemId, "score" => $score]);
    }
    /**
     * 获取预评分列表
     * @return  mixed
    */
    public static function getPreScoreList (string $poolType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPreScoreList(["poolType" => $poolType]);
    }
    /**
     * 最终确认
     * @return  mixed
    */
    public static function confirm (string $poolType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirm(["poolType" => $poolType]);
    }
    /**
     * 预检查是否可以更新配置
     * @return  mixed
    */
    public static function preCheckUpdateConfig (string $poolType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->preCheckUpdateConfig(["poolType" => $poolType]);
    }
    /**
     * 锁配置
     * @return  mixed
    */
    public static function lockUpdateConfig (string $poolType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->lockUpdateConfig(["poolType" => $poolType]);
    }
    /**
     * 解锁配置
     * @return  mixed
    */
    public static function unlockUpdateConfig (string $poolType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unlockUpdateConfig(["poolType" => $poolType]);
    }
    /**
     * 获取评分配置
     * @return  mixed
    */
    public static function getScoreConfig (string $poolType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getScoreConfig(["poolType" => $poolType]);
    }
    /**
     * 评分配置调整
     * @return  mixed
    */
    public static function updateScoreConfig (string $poolType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateScoreConfig(["poolType" => $poolType]);
    }
    /**
     * 查询评分历史记录
     * @return  mixed
    */
    public static function queryRecordHistory (string $poolType, string $startTime, string $endTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryRecordHistory(["poolType" => $poolType, "startTime" => $startTime, "endTime" => $endTime]);
    }
    /**
     * 查询质量报告
     * @return  mixed
    */
    public static function queryQualityReport (string $poolType, string $startTime, string $endTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryQualityReport(["poolType" => $poolType, "startTime" => $startTime, "endTime" => $endTime]);
    }
    /**
     * 查询聚合数据
     * @return  mixed
    */
    public static function queryHistoryAggregate (string $poolType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryHistoryAggregate(["poolType" => $poolType]);
    }
    /**
     * 通过伙伴获取有权限的门店信息
     * @return  mixed
    */
    public static function getStoreIdsByStaff (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsByStaff(["staffIds" => $staffIds]);
    }
    /**
     * 获取伙伴(根据入职时间)
     * @return  mixed
    */
    public static function getStaff () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaff([]);
    }
    /**
     * 获取流水信息
     * @return  mixed
    */
    public static function getStreamInfo (string $poolType, int $cloudStreamId, string $startTime, string $endTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamInfo(["poolType" => $poolType, "cloudStreamId" => $cloudStreamId, "startTime" => $startTime, "endTime" => $endTime]);
    }
    /**
     * 定时任务提交最终评分
     * @return  mixed
    */
    public static function cronSubmitFinalCommit () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronSubmitFinalCommit();
    }
    /**
     * 删除评分
     * @return  mixed
    */
    public static function delScore (string $poolType, int $cloudStreamId, string $startTime, string $endTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delScore(["poolType" => $poolType, "cloudStreamId" => $cloudStreamId, "startTime" => $startTime, "endTime" => $endTime]);
    }
    /**
     * 获取摄影化妆问题标签
     * @return  mixed
    */
    public static function getPhotoProblemTagSets () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoProblemTagSets([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}