<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-06 14:41:15
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class UnreviewedGuestPhotos
 * @method uploadByParams(array $params) 授权通过，加入客片审核中
 * @method getUploadInfoByParams(array $params) 返回已经上传的客片信息
 * @method listByParams(array $params) 获取客片审核列表
 * @method updateUpdatedAtByIdsByParams(array $params) 更新客片更新时间
 * @method openNextBatchByParams(array $params) 开启下一批审核
 * @method auditByParams(array $params) 客片批量审核
 * @method areaSelectByParams(array $params) 客片审核区域下拉数据
 * @method getStaffRoleAuthByParams(array $params) 得到当前用户角色权限
 * @method messageRemindingByParams(array $params) 消息提醒
 * @method overdueRemoveByParams(array $params) 定时任务自动下架已下架的产品的样片
 */
class UnreviewedGuestPhotos {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\UnreviewedGuestPhotos";

    /**
     * 授权通过，加入客片审核中
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedGuestPhotos\Dto\UploadResDto
    */
    public static function upload (int $store_id, int $order_id, array $images) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->upload(["store_id" => $store_id, "order_id" => $order_id, "images" => $images]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedGuestPhotos\Dto\UploadResDto"
        );
    }
    /**
     * 返回已经上传的客片信息
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedGuestPhotos\Dto\UploadInfoDto
    */
    public static function getUploadInfo (int $order_id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUploadInfo(["order_id" => $order_id]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedGuestPhotos\Dto\UploadInfoDto"
        );
    }
    /**
     * 获取客片审核列表
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedGuestPhotos\Dto\UnreviewedGuestPhotoListDto
    */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list([]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedGuestPhotos\Dto\UnreviewedGuestPhotoListDto"
        );
    }
    /**
     * 更新客片更新时间
     * @return  int
    */
    public static function updateUpdatedAtByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateUpdatedAtByIds(["ids" => $ids]);
    }
    /**
     * 开启下一批审核
     * @return  bool
    */
    public static function openNextBatch () {
        return RpcClass::getClass(self::$serviceName, self::$className)->openNextBatch();
    }
    /**
     * 客片批量审核
     * @return  bool
    */
    public static function audit (array $ids, string $result) {
        return RpcClass::getClass(self::$serviceName, self::$className)->audit(["ids" => $ids, "result" => $result]);
    }
    /**
     * 客片审核区域下拉数据
     * @return  array
    */
    public static function areaSelect () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->areaSelect(),
            "\Mainto\Bridge\Structs\HimoProduct\SelectDto[]"
        );
    }
    /**
     * 得到当前用户角色权限
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedGuestPhotos\Dto\StaffRoleAuthDto
    */
    public static function getStaffRoleAuth () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStaffRoleAuth(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedGuestPhotos\Dto\StaffRoleAuthDto"
        );
    }
    /**
     * 消息提醒
     * @return  void
    */
    public static function messageReminding () {
         RpcClass::getClass(self::$serviceName, self::$className)->messageReminding();
    }
    /**
     * 定时任务自动下架已下架的产品的样片
     * @return  void
    */
    public static function overdueRemove () {
         RpcClass::getClass(self::$serviceName, self::$className)->overdueRemove();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}