<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-15 17:24:22
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Role
 * @method listByParams(array $params) 获取角色列表
 * @method allByParams(array $params) 获取角色列表
 * @method createByParams(array $params) 创建角色
 * @method detailByParams(array $params) 角色信息
 * @method updateByParams(array $params) 设置角色权限
 * @method deleteByParams(array $params) 删除角色
 * @method memberByParams(array $params) 获取拥有某权限组的伙伴(分页)
 */
class Role {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Role";

    /**
     * 获取角色列表
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }
    /**
     * 获取角色列表
     * @return  mixed
    */
    public static function all () {
        return RpcClass::getClass(self::$serviceName, self::$className)->all([]);
    }
    /**
     * 创建角色
     * @return  int
    */
    public static function create (string $title, array $permission_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["title" => $title, "permission_ids" => $permission_ids]);
    }
    /**
     * 角色信息
     * @return  mixed
    */
    public static function detail (int $role_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["role_id" => $role_id]);
    }
    /**
     * 设置角色权限
     * @return  bool
    */
    public static function update (int $role_id, array $permission_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["role_id" => $role_id, "permission_ids" => $permission_ids]);
    }
    /**
     * 删除角色
     * @return  bool
    */
    public static function delete (int $role_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["role_id" => $role_id]);
    }
    /**
     * 获取拥有某权限组的伙伴(分页)
     * @return  mixed
    */
    public static function member (int $role_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->member(["role_id" => $role_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}