<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-16 16:34:47
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Exploit
 * @method createByParams(array $params) 录入每日业绩核对
 * @method updateByParams(array $params) 更新业绩
 * @method searchByParams(array $params) 查询业绩
 * @method exportByParams(array $params) 导出业绩
 * @method isCheckByParams(array $params) 昨日业绩是否已核对
 * @method detailByParams(array $params) 业绩详情
 */
class Exploit {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Exploit";

    /**
     * 录入每日业绩核对
     * @return  mixed
    */
    public static function create (string $report_date, float $report_market_performance, int $report_count, int $system_shoot_count, float $alipay, float $alipay_system, float $wechat, float $wechat_system, float $pos, float $pos_system, float $cash, float $cash_system, float $market_card, float $market_card_system) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["report_date" => $report_date, "report_market_performance" => $report_market_performance, "report_count" => $report_count, "system_shoot_count" => $system_shoot_count, "alipay" => $alipay, "alipay_system" => $alipay_system, "wechat" => $wechat, "wechat_system" => $wechat_system, "pos" => $pos, "pos_system" => $pos_system, "cash" => $cash, "cash_system" => $cash_system, "market_card" => $market_card, "market_card_system" => $market_card_system]);
    }
    /**
     * 更新业绩
     * @return  mixed
    */
    public static function update (string $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id]);
    }
    /**
     * 查询业绩
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Exploit\Dto\ExploitPageDto
    */
    public static function search () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->search([]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Exploit\Dto\ExploitPageDto"
        );
    }
    /**
     * 导出业绩
     * @return  array
    */
    public static function export () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->export([]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Exploit\Dto\ExploitExportDto[]"
        );
    }
    /**
     * 昨日业绩是否已核对
     * @return  mixed
    */
    public static function isCheck () {
        return RpcClass::getClass(self::$serviceName, self::$className)->isCheck();
    }
    /**
     * 业绩详情
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Exploit\Dto\ExploitDetailDto
    */
    public static function detail () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail([]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Exploit\Dto\ExploitDetailDto"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}