<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-27 17:16:34
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class GiftCard
 */
class GiftCard {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\GiftCard";

    /**
     * 礼品卡作废
     * @return  mixed
    */
    public static function abolish (array $card_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolish(["card_ids" => $card_ids]);
    }
    /**
     * 获取礼品卡信息
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 获取礼品卡列表(分页)
     * @return  mixed
    */
    public static function list (int $id, string $status, int $user_id, string $code, bool $with_cover_info, int $create_log_id, string $created_at_start, string $created_at_end, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["id" => $id, "status" => $status, "user_id" => $user_id, "code" => $code, "with_cover_info" => $with_cover_info, "create_log_id" => $create_log_id, "created_at_start" => $created_at_start, "created_at_end" => $created_at_end, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 获取创建日志列表
     * @return  mixed
    */
    public static function allCreateLog () {
        return RpcClass::getClass(self::$serviceName, self::$className)->allCreateLog();
    }
    /**
     * 搜索礼品卡
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\GiftCard\Search\Dto\SearchUserGiftCardListDto
    */
    public static function search (int $id, string $code, string $status, string $mobile, int $page) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->search(["id" => $id, "code" => $code, "status" => $status, "mobile" => $mobile, "page" => $page]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\GiftCard\Search\Dto\SearchUserGiftCardListDto"
        );
    }
    /**
     * 礼品卡详情
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\GiftCard\DetailInfo\Dto\DetailInfoDto
    */
    public static function detailInfo (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detailInfo(["id" => $id]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\GiftCard\DetailInfo\Dto\DetailInfoDto"
        );
    }
    /**
     * 获取礼品卡支付记录分页列表
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\GiftCard\PaymentList\Dto\PaymentListDto
    */
    public static function paymentList (int $cardId, int $page, int $pageSize) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->paymentList(["cardId" => $cardId, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\GiftCard\PaymentList\Dto\PaymentListDto"
        );
    }
    /**
     * 获取用户礼品卡余额
     * @return  mixed
    */
    public static function balance (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->balance(["user_id" => $user_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}