<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-24 17:02:05
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Workload
 */
class Workload {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Workload";

    /**
     * 门店录入工作量-已转移到门店端
     * @return  mixed
    */
    public static function create (int $order_id, array $workloads) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["order_id" => $order_id, "workloads" => $workloads]);
    }
    /**
     * 重置工作量
     * @return  bool
    */
    public static function reset (int $order_id, array $workloads) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reset(["order_id" => $order_id, "workloads" => $workloads]);
    }
    /**
     * 处理工作量事件
     * @return  string
    */
    public static function dealWorkloadEvent (bool $right_now) {
        return RpcClass::getClass(self::$serviceName, self::$className)->dealWorkloadEvent(["right_now" => $right_now]);
    }
    /**
     * 工作量查询
     * @return  array
    */
    public static function detail (string $order_num) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["order_num" => $order_num]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Workload\Dto\WorkloadDto[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}