<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-19 18:52:35
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductArea
 */
class ProductArea {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\ProductArea";

    /**
     * 多个价格区绑定价格
     * @return  bool
    */
    public static function areaIdsBindPrice (int $product_id, array $price_area_ids, int $price_id, float $price, float $original_price, float $add_people_price, float $deposit_price = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->areaIdsBindPrice(["product_id" => $product_id, "price_area_ids" => $price_area_ids, "price_id" => $price_id, "price" => $price, "original_price" => $original_price, "add_people_price" => $add_people_price, "deposit_price" => $deposit_price]);
    }
    /**
     * 多个价格区解绑价格
     * @return  mixed
    */
    public static function areaIdsUnbindPrice (array $price_area_ids, int $price_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->areaIdsUnbindPrice(["price_area_ids" => $price_area_ids, "price_id" => $price_id]);
    }
    /**
     * 分区绑定门店(非增量)
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\Dto\AreaBindStoreDto
    */
    public static function areaBindStore (int $area_id, array $store_ids = [], string $type = 'price') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->areaBindStore(["area_id" => $area_id, "store_ids" => $store_ids, "type" => $type]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\Dto\AreaBindStoreDto"
        );
    }
    /**
     * 分区绑定门店后续
     * @return  mixed
    */
    public static function afterAreaBindStore (array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterAreaBindStore(["storeIds" => $storeIds]);
    }
    /**
     * 新增门店分区
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\Dto\AreaDto
    */
    public static function areaAdd (string $name, string $module, string $type = 'price') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->areaAdd(["name" => $name, "module" => $module, "type" => $type]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\Dto\AreaDto"
        );
    }
    /**
     * 所有门店分区
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\Dto\AreaAllDto
    */
    public static function areaAll (string $module, string $type = '') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->areaAll(["module" => $module, "type" => $type]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\Dto\AreaAllDto"
        );
    }
    /**
     * 编辑门店分区
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\Dto\AreaDto
    */
    public static function areaUpdate (int $area_id, string $name, string $module, string $type = 'price') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->areaUpdate(["area_id" => $area_id, "name" => $name, "module" => $module, "type" => $type]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\Dto\AreaDto"
        );
    }
    /**
     * 删除门店分区
     * @return  bool
    */
    public static function areaDelete (int $area_id, string $type = 'price') {
        return RpcClass::getClass(self::$serviceName, self::$className)->areaDelete(["area_id" => $area_id, "type" => $type]);
    }
    /**
     * 更新加修加印价格
     * @return  bool
    */
    public static function updateJxjyGonggePrice (int $price_id, \Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\UpdateJxjyGonggePriceParamsJxjyPrice $jxjyPrice, \Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\UpdateJxjyGonggePriceParamsGonggeInfo $gonggeInfo, \Mainto\Bridge\Structs\HimoProduct\Admin\ProductArea\UpdateJxjyGonggePriceParamsGonggePrice $gongge_price) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateJxjyGonggePrice(["price_id" => $price_id, "jxjyPrice" => $jxjyPrice, "gonggeInfo" => $gonggeInfo, "gongge_price" => $gongge_price]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}