<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-10-25 16:01:03
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Manger
 */
class Manger {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Manger";

    /**
     * 获取管理员列表
     * @return  mixed
    */
    public static function list (int $page = 1, int $page_size = 15, string $staff_name, string $type = 'core') {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "page_size" => $page_size, "staff_name" => $staff_name, "type" => $type]);
    }
    /**
     * 创建管理员
     * @return  bool
    */
    public static function create (int $staff_id, string $type = 'core') {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["staff_id" => $staff_id, "type" => $type]);
    }
    /**
     * 修改管理员启用状态
     * @return  bool
    */
    public static function enable (int $staff_id, int $status, string $type = 'core') {
        return RpcClass::getClass(self::$serviceName, self::$className)->enable(["staff_id" => $staff_id, "status" => $status, "type" => $type]);
    }
    /**
     * 获取管理员
     * @return  mixed
    */
    public static function detail (int $id, string $type = 'core') {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, "type" => $type]);
    }
    /**
     * 给管理员授权角色
     * @return  bool
    */
    public static function grantRole (int $id, array $role_ids, string $type = 'core') {
        return RpcClass::getClass(self::$serviceName, self::$className)->grantRole(["id" => $id, "role_ids" => $role_ids, "type" => $type]);
    }
    /**
     * 撤销伙伴角色
     * @return  mixed
    */
    public static function revokeStaffRole (int $role_id, int $staff_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->revokeStaffRole(["role_id" => $role_id, "staff_id" => $staff_id]);
    }
    /**
     * 给管理员授权权限
     * @return  mixed
    */
    public static function grantPermissions (int $staff_id, array $permission_ids = [], string $type = 'core') {
        return RpcClass::getClass(self::$serviceName, self::$className)->grantPermissions(["staff_id" => $staff_id, "permission_ids" => $permission_ids, "type" => $type]);
    }
    /**
     * 通过伙伴姓名或花名获得可能的工号
     * @return  mixed
    */
    public static function search (string $staff_name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->search(["staff_name" => $staff_name]);
    }
    /**
     * 管理员授权门店
     * @return  bool
    */
    public static function grantStore (int $staff_id, array $store_ids, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->grantStore(["staff_id" => $staff_id, "store_ids" => $store_ids, "type" => $type]);
    }
    /**
     * 获取管理员授权门店列表
     * @return  mixed
    */
    public static function storePermission (int $staff_id, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storePermission(["staff_id" => $staff_id, "type" => $type]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}