<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-10-25 16:01:03
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Category
 */
class Category {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Category";

    /**
     * 创建类目
     * @return  mixed
    */
    public static function create (string $name, string $module, int $parent_id, string $eng_name, string $full_name, int $sort, bool $multiple, array $extend, string $status, string $comment) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "module" => $module, "parent_id" => $parent_id, "eng_name" => $eng_name, "full_name" => $full_name, "sort" => $sort, "multiple" => $multiple, "extend" => $extend, "status" => $status, "comment" => $comment]);
    }
    /**
     * 产品类目详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 删除产品类目
     * @return  bool
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 更新类目
     * @return  mixed
    */
    public static function update (int $id, string $module, string $name, int $parent_id, string $eng_name, string $full_name, int $sort, bool $multiple, array $extend, string $status, string $comment) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "module" => $module, "name" => $name, "parent_id" => $parent_id, "eng_name" => $eng_name, "full_name" => $full_name, "sort" => $sort, "multiple" => $multiple, "extend" => $extend, "status" => $status, "comment" => $comment]);
    }
    /**
     * 更改类目状态
     * @return  mixed
    */
    public static function updateStatus (int $id, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStatus(["id" => $id, "status" => $status]);
    }
    /**
     * 获取类目所有子集
     * @return  mixed
    */
    public static function getCategoryChild (int $id, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryChild(["id" => $id, "type" => $type]);
    }
    /**
     * 类目列表
     * @return  mixed
    */
    public static function getProductCategoryList (int $page, int $page_size, string $name, string $full_name, int $parent_id, bool $show_deleted, bool $c_hidden, bool $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCategoryList(["page" => $page, "page_size" => $page_size, "name" => $name, "full_name" => $full_name, "parent_id" => $parent_id, "show_deleted" => $show_deleted, "c_hidden" => $c_hidden, "status" => $status]);
    }
    /**
     * 类目列表
     * @return  mixed
    */
    public static function getProductCategoryAll (string $name, string $full_name, int $parent_id, bool $show_deleted, bool $c_hidden, bool $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCategoryAll(["name" => $name, "full_name" => $full_name, "parent_id" => $parent_id, "show_deleted" => $show_deleted, "c_hidden" => $c_hidden, "status" => $status]);
    }
    /**
     * 修改extend
     * @return  mixed
    */
    public static function editExtend (int $id, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editExtend(["id" => $id, "extend" => $extend]);
    }
    /**
     * 获取树状类目
     * @return  mixed
    */
    public static function getCategoryTree (int $show_level, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryTree(["show_level" => $show_level, "status" => $status]);
    }
    /**
     * 开启/关闭该类目下产品预约端是否显示
     * @return  bool
    */
    public static function setCHiddenStatus (int $id, bool $c_hidden) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setCHiddenStatus(["id" => $id, "c_hidden" => $c_hidden]);
    }
    /**
     * 类目拖拽排序
     * @return  bool
    */
    public static function dragCategory (int $current_id, int $target_parent_id, int $target_sort) {
        return RpcClass::getClass(self::$serviceName, self::$className)->dragCategory(["current_id" => $current_id, "target_parent_id" => $target_parent_id, "target_sort" => $target_sort]);
    }
    /**
     * 获取某产品组所有服装
     * @return  mixed
    */
    public static function allCloth (int $category_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->allCloth(["category_id" => $category_id]);
    }
    /**
     * 产品组添加服装
     * @return  mixed
    */
    public static function createCloth (int $category_id, string $gender, string $image, int $cloth_group_id, int $sort) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createCloth(["category_id" => $category_id, "gender" => $gender, "image" => $image, "cloth_group_id" => $cloth_group_id, "sort" => $sort]);
    }
    /**
     * 更新服装
     * @return  mixed
    */
    public static function updateCloth (int $cloth_id, string $gender, string $image, int $cloth_group_id, int $sort) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateCloth(["cloth_id" => $cloth_id, "gender" => $gender, "image" => $image, "cloth_group_id" => $cloth_group_id, "sort" => $sort]);
    }
    /**
     * 删除服装
     * @return  bool
    */
    public static function deleteCloth (int $cloth_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteCloth(["cloth_id" => $cloth_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}