<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-10-25 16:01:03
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Announcement
 */
class Announcement {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Announcement";

    /**
     * 获取公告发布人
     * @return  array
    */
    public static function announcementPublisher () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->announcementPublisher(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\PublisherDto[]"
        );
    }
    /**
     * 获取公告接收角色
     * @return  array
    */
    public static function getRoles () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRoles();
    }
    /**
     * 获取公告列表
     * @return  array
    */
    public static function announcementList (?\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementSearch $announcementSearch = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->announcementList($announcementSearch),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\Announcement[]"
        );
    }
    /**
     * 获取公告列表(分页)
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\AnnouncementListWithPage
    */
    public static function announcementListWithPage (?\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementSearch $announcementSearch = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->announcementListWithPage($announcementSearch),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\AnnouncementListWithPage"
        );
    }
    /**
     * 创建公告
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\Announcement
    */
    public static function createAnnouncement (\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementCreate $announcementCreate) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createAnnouncement($announcementCreate),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\Announcement"
        );
    }
    /**
     * 编辑公告
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\Announcement
    */
    public static function editAnnouncement (\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementEdit $announcementEdit) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->editAnnouncement($announcementEdit),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\Announcement"
        );
    }
    /**
     * 公告详情
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\AnnouncementAppendInfo
    */
    public static function announcementDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->announcementDetail(["id" => $id]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\AnnouncementAppendInfo"
        );
    }
    /**
     * 作废公告
     * @return  bool
    */
    public static function abolish (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolish(["id" => $id]);
    }
    /**
     * 导出公告阅读报告
     * @return  array
    */
    public static function exportReadReport (array $messageIds) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->exportReadReport(["messageIds" => $messageIds]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\ReadReport[]"
        );
    }
    /**
     * 获取指定日期的弹窗
     * @return  array
    */
    public static function getPops (string $date) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPops(["date" => $date]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\Announcement[]"
        );
    }
    /**
     * 读公告
     * @return  bool
    */
    public static function readAnnouncement (int $reader, int $messageId, string $readerType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->readAnnouncement(["reader" => $reader, "messageId" => $messageId, "readerType" => $readerType]);
    }
    /**
     * 获取未读消息ids
     * @return  array
    */
    public static function getWaitReadMessages (int $reader) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWaitReadMessages(["reader" => $reader]);
    }
    /**
     * 创建公告板块
     * @return  bool
    */
    public static function createAnnouncementCategory (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createAnnouncementCategory(["name" => $name]);
    }
    /**
     * 编辑公告板块
     * @return  bool
    */
    public static function editAnnouncementCategory (\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementCategoryEdit $announcementCategoryEdit) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editAnnouncementCategory($announcementCategoryEdit);
    }
    /**
     * 删除公告板块
     * @return  bool
    */
    public static function deleteAnnouncementCategory (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteAnnouncementCategory(["id" => $id]);
    }
    /**
     * 获取公告板块
     * @return  array
    */
    public static function getAnnouncementCategory () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAnnouncementCategory(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\AnnouncementCategory[]"
        );
    }
    /**
     * 获取公告部门树
     * @return  array
    */
    public static function departmentTree (int $beginDepartmentId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->departmentTree(["beginDepartmentId" => $beginDepartmentId]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\DepartmentTree[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}