<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-11-08 17:56:30
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductAudit
 */
class ProductAudit {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\ProductAudit";

    /**
     * 审批产品列表
     * @return  array
    */
    public static function list (string $productName, array $brands, string $type, bool $existAuditing, string $status, int $page = 1, int $pageSize = 100) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["productName" => $productName, "brands" => $brands, "type" => $type, "existAuditing" => $existAuditing, "status" => $status, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 批量上线
     * @return  bool
    */
    public static function batchUp (array $productIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUp(["productIds" => $productIds]);
    }
    /**
     * 获取brands
     * @return  array
    */
    public static function getBrands () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBrands();
    }
    /**
     * 获取审批中差异
     * @return  array
    */
    public static function getChange (int $productId, int $productAuditId, array $subtypes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getChange(["productId" => $productId, "productAuditId" => $productAuditId, "subtypes" => $subtypes]);
    }
    /**
     * 产品/子套餐修改备案
     * @return  bool
    */
    public static function startUpdate (array $data, string $brand, int $productId, string $fullName, string $subtype) {
        return RpcClass::getClass(self::$serviceName, self::$className)->startUpdate(["data" => $data, "brand" => $brand, "productId" => $productId, "fullName" => $fullName, "subtype" => $subtype]);
    }
    /**
     * 产品/子套餐修改备案
     * @return  mixed
    */
    public static function setAuditStatus (array $ids, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setAuditStatus(["ids" => $ids, "status" => $status]);
    }
    /**
     * 更新产品状态
     * @return  mixed
    */
    public static function setStatus () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setStatus();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}