<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-10-16 17:17:53
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Store
 */
class Store {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Store";

    /**
     * 获取门店列表
     * @return  mixed
    */
    public static function list (string $name, int $group_id, string $affiliate_type, int $province_id, int $city_id, int $area_id, int $city_type_id, string $store_type, string $status, int $page) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["name" => $name, "group_id" => $group_id, "affiliate_type" => $affiliate_type, "province_id" => $province_id, "city_id" => $city_id, "area_id" => $area_id, "city_type_id" => $city_type_id, "store_type" => $store_type, "status" => $status, "page" => $page]);
    }
    /**
     * 门店列表信息导出
     * @return  mixed
    */
    public static function export () {
        return RpcClass::getClass(self::$serviceName, self::$className)->export();
    }
    /**
     * 获取有门店的所有城市
     * @return  mixed
    */
    public static function city (array $store_type, bool $includeDelete) {
        return RpcClass::getClass(self::$serviceName, self::$className)->city(["store_type" => $store_type, "includeDelete" => $includeDelete]);
    }
    /**
     * 根据分组获取门店(不传参数则为全部)
     * @return  mixed
    */
    public static function all (string $classification, int $sc_id, bool $include_delete, string $store_type, bool $only_mantu) {
        return RpcClass::getClass(self::$serviceName, self::$className)->all(["classification" => $classification, "sc_id" => $sc_id, "include_delete" => $include_delete, "store_type" => $store_type, "only_mantu" => $only_mantu]);
    }
    /**
     * 创建门店
     * @return  mixed
    */
    public static function create (string $name, int $city_id, int $city_type_id, int $sc_id, int $province_id, int $group_id, int $dept_id, string $store_type, string $affiliate_type, string $start_appointment_time, string $stop_appointment_time,  $extend, int $service_interval, int $service_times, string $start_business, int $sort, string $dianping_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "city_id" => $city_id, "city_type_id" => $city_type_id, "sc_id" => $sc_id, "province_id" => $province_id, "group_id" => $group_id, "dept_id" => $dept_id, "store_type" => $store_type, "affiliate_type" => $affiliate_type, "start_appointment_time" => $start_appointment_time, "stop_appointment_time" => $stop_appointment_time, "extend" => $extend, "service_interval" => $service_interval, "service_times" => $service_times, "start_business" => $start_business, "sort" => $sort, "dianping_id" => $dianping_id]);
    }
    /**
     * 获取门店信息
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 获取所有区域经理
     * @return  mixed
    */
    public static function managers () {
        return RpcClass::getClass(self::$serviceName, self::$className)->managers();
    }
    /**
     * 修改门店信息
     * @return  bool
    */
    public static function update (string $name, int $city_id, int $sc_id, int $province_id, int $group_id, int $id, string $affiliate_type, string $start_appointment_time, string $stop_appointment_time, int $service_times,  $extend, int $sort, string $use_pos_status, string $dianping_id, string $start_business) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["name" => $name, "city_id" => $city_id, "sc_id" => $sc_id, "province_id" => $province_id, "group_id" => $group_id, "id" => $id, "affiliate_type" => $affiliate_type, "start_appointment_time" => $start_appointment_time, "stop_appointment_time" => $stop_appointment_time, "service_times" => $service_times, "extend" => $extend, "sort" => $sort, "use_pos_status" => $use_pos_status, "dianping_id" => $dianping_id, "start_business" => $start_business]);
    }
    /**
     * 门店下线
     * @return  mixed
    */
    public static function noRelease (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->noRelease(["id" => $id]);
    }
    /**
     * 门店上线
     * @return  bool
    */
    public static function release (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->release(["id" => $id]);
    }
    /**
     * 获取部门列表
     * @return  mixed
    */
    public static function getDepartmentList (string $type, bool $no_bind_store) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDepartmentList(["type" => $type, "no_bind_store" => $no_bind_store]);
    }
    /**
     * 门店pos绑定事件
     * @return  mixed
    */
    public static function hookStoreUsePosStatus (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookStoreUsePosStatus(["storeId" => $storeId]);
    }
    /**
     * 获取所有未营业门店
     * @return  mixed
    */
    public static function getNotOpenStoreAll () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNotOpenStoreAll();
    }
    /**
     * 批量设置所有未营业门店
     * @return  bool
    */
    public static function batchSetAllNotOpenStore (array $storeIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchSetAllNotOpenStore(["storeIds" => $storeIds]);
    }
    /**
     * 根据价格区获取城市ids
     * @return  mixed
    */
    public static function getCityIdsByPriceAreaIds (string $price_area_ids = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCityIdsByPriceAreaIds(["price_area_ids" => $price_area_ids]);
    }
    /**
     * 集团列表
     * @return  mixed
    */
    public static function getGroups (int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroups(["page" => $page, "page_size" => $page_size]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}