<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchCreateByParams(array $params)
 * @method abolishedByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method searchByParams(array $params)
 * @method createLogListByParams(array $params)
 * @method batchSendCouponByParams(array $params)
 * @method getLogsByParams(array $params)
 */
class PreferentialCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量生成优惠券
     *
     * @support  string $title 标题 [ require true ]
     * @support  int $template_id 模板id [ require false ]
     * @support  int $count 创建数量 [ require false ]
     * @support  float $discount 折扣 [ require true ]
     * @support  float $ori_money 原金额 [ require false ]
     * @support  string $apply_in 应用于 [ require false ]
     * @support  string $stop_usage 结束使用时间 [ require false ]
     * @support  string $start_usage 开始生效时间 [ require false ]
     * @support  float $pay_money 收金额 [ require false ]
     * @support  string $buy_channel 购买渠道 [ require false ]
     * @support  int $sale_store_id 售卖门店 [ require false ]
     * @support  array $extend 拓展信息 [ require false ]
     * @throws  \Exception
     * @return  int
     */
    public static function batchCreate () {
        return self::getClass()->batchCreate([
        ]);
    }

    /**
     * 优惠券作废
     *
     * @support  array $codes 码数组 [ require false ]
     * @support  array $ids ids数组 [ require false ]
     * @support  array $extend 额外信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function abolished () {
        return self::getClass()->abolished([
        ]);
    }

    /**
     * 获取兑换码列表(分页)
     *
     * @support  string $type 优惠券类型 [ require false ]
     * @support  string $mobile 手机号 [ require false ]
     * @support  int $user_id 用户id [ require false ]
     * @support  string $created_at_start 生成时间起 [ require false ]
     * @support  string $created_at_end 生成时间止 [ require false ]
     * @support  string $used_at_start 使用时间起 [ require false ]
     * @support  string $used_at_end 使用时间止 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $apply_in 使用模块 [ require false ]
     * @support  string $code 兑换码 [ require false ]
     * @support  int $create_log_id 创建记录id [ require false ]
     * @support  bool $with_template_info 包含卡面信息 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 获取兑换码列表(所有)
     *
     * @support  string $mobile 手机号 [ require false ]
     * @support  string $type 优惠券类型 [ require false ]
     * @support  int $user_id 用户id [ require false ]
     * @support  string $apply_in 应用于 [ require false ]
     * @support  string $created_at_start 生成时间起 [ require false ]
     * @support  string $created_at_end 生成时间止 [ require false ]
     * @support  string $used_at_start 使用时间起 [ require false ]
     * @support  string $used_at_end 使用时间止 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  array $code 兑换码 [ require false ]
     * @support  int $create_log_id 创建记录id [ require false ]
     * @support  bool $with_template_info 包含卡面信息 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\PreferentialCard\Dto\PreferentialCardAllDto[]
     */
    public static function all () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->all([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\PreferentialCard\Dto\PreferentialCardAllDto[]"
        );
    }

    /**
     * 优惠券单个码查询
     *
     * @support  string $mobile 手机号 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $code 兑换码 [ require false ]
     * @support  int $product_id 适用产品 [ require false ]
     * @support  int $store_id 适用门店 [ require false ]
     * @support  bool $action_scope 是否可以用于升级服务 [ require false ]
     * @support  string $description 描述 [ require false ]
     * @support  string $used_at_end 使用时间止 [ require false ]
     * @support  string $used_at_start 使用时间起 [ require false ]
     * @support  string $apply_in 应用于 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\PreferentialCard\Dto\PreferentialCardSearchDto
     */
    public static function search () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->search([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\PreferentialCard\Dto\PreferentialCardSearchDto"
        );
    }

    /**
     * 优惠券渠道领券查询
     *
     * @support  int $channel 渠道号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createLogList () {
        return self::getClass()->createLogList([
        ]);
    }

    /**
     * 批量发放优惠券
     *
     * @support  string $reason 生成原因 [ require false ]
     * @support  int $channel 渠道 [ require false ]
     * @support  string $apply_in 应用于 [ require false ]
     * @support  array $user_phone 用户手机号 [ require false ]
     * @support  array $coupon_info_array 优惠券模版信息 [ require false ]
     * @support  array $product_info_array 产品卡模版信息 [ require false ]
     * @support  int $staff_id 操作人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchSendCoupon () {
        return self::getClass()->batchSendCoupon([
        ]);
    }

    /**
     * 优惠券创建记录查询
     *
     * @support  array $ids 记录ids [ require false ]
     * @support  array $channel 渠道号 [ require false ]
     * @support  string $type 模板类型 [ require false ]
     * @support  string $created_at_end 创建时间止 [ require false ]
     * @support  string $created_at_start 创建时间起 [ require false ]
     * @support  bool $with_template_info 包含模板信息 [ require false ]
     * @support  string $apply_in 应用于 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLogs () {
        return self::getClass()->getLogs([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\PreferentialCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\PreferentialCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}