<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method passByParams(array $params)
 * @method rejectByParams(array $params)
 * @method handleInvoiceProcessedByParams(array $params)
 * @method refundAbnormalFinanceHandledByParams(array $params)
 */
class RetailOrderRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 退款列表
     *
     * @support  string $brand 品牌 [ require false ]
     * @support  string $order_no 订单号 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $apply_time_start 申请时间-开始 [ require false ]
     * @support  string $apply_time_end 申请时间-结束 [ require false ]
     * @support  string $process_time_start 处理时间-开始 [ require false ]
     * @support  string $process_time_end 处理时间-结束 [ require false ]
     * @support  int $page  [ require false ]
     * @support  int $page_size  [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 通过退款
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pass (int $id) {
        return self::getClass()->pass([
            "id" => $id,
        ]);
    }

    /**
     * 拒绝退款
     *
     * @param  int $id 退款ID [ require true ]
     * @param  string $reason 退款原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reject (int $id, string $reason) {
        return self::getClass()->reject([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * TODO 权限
     *
     * @param  int $refundId 退款单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleInvoiceProcessed (int $refundId) {
        return self::getClass()->handleInvoiceProcessed([
            "refundId" => $refundId,
        ]);
    }

    /**
     * 财务已处理-处理拉卡拉异常的退款单
     *
     * @param  int $id 退款单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundAbnormalFinanceHandled (int $id) {
        return self::getClass()->refundAbnormalFinanceHandled([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\RetailOrderRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\RetailOrderRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}