<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method createCallByStoreByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByNoByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method closeByParams(array $params)
 * @method itemsByParams(array $params)
 * @method payByParams(array $params)
 * @method changePayTypeByParams(array $params)
 */
class OfflineOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建线下订单
     *
     * @support  int $amount  [ require true ]
     * @support  float $money 订单金额 [ require false ]
     * @support  int $income_item_id 线下收入项目ID [ require true ]
     * @support  string $note 备注 [ require false ]
     * @support  array $coupon_ids 券码ids [ require false ]
     * @support  int $user_id 用户ID [ require false ]
     * @support  array $print_nums 打印数量 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderDetailDto
     */
    public static function create () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderDetailDto"
        );
    }

    /**
     * 用于门店端请求 - 创建线下订单
     *
     * @support  int $amount  [ require true ]
     * @support  float $money 订单金额 [ require false ]
     * @support  int $income_item_id 线下收入项目ID [ require true ]
     * @support  string $note 备注 [ require false ]
     * @support  array $coupon_ids 券码ids [ require false ]
     * @support  int $user_id 用户ID [ require false ]
     * @support  array $print_nums 打印数量 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderDetailDto
     */
    public static function createCallByStore () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createCallByStore([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderDetailDto"
        );
    }

    /**
     * 线下订单详情
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderDetailDto
     */
    public static function detail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderDetailDto"
        );
    }

    /**
     * 线下订单详情【更加订单号】
     *
     * @support  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderDetailByNoDto
     */
    public static function detailByNo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detailByNo([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderDetailByNoDto"
        );
    }

    /**
     * 线下订单列表
     *
     * @support  string $pay_type 支付类型，同子订单支付类型 [ require false ]
     * @support  int $item_id 收入项id [ require false ]
     * @support  int $store_id 门店id [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $status_list 状态列表 [ require false ]
     * @support  string $order_no 订单编号 [ require false ]
     * @support  string $paid_at_start 支付时间起始 [ require false ]
     * @support  string $paid_at_end 支付时间结束 [ require false ]
     * @support  string $brand 品牌 [ require false ]
     * @support  int $page  [ require false ]
     * @support  int $page_size  [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderListDto
     */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderListDto"
        );
    }

    /**
     * 取消线下订单
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete () {
        return self::getClass()->delete([
        ]);
    }

    /**
     * 关闭线下订单
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function close () {
        return self::getClass()->close([
        ]);
    }

    /**
     * 线下产品
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\ItemsDto[]
     */
    public static function items () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->items(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\ItemsDto[]"
        );
    }

    /**
     * 线下订单支付
     *
     * @support  int $id 订单id [ require true ]
     * @support  string $pay_type 支付方式 [ require true ]
     * @support  string $payment_no 支付流水号 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderListDetailDto
     */
    public static function pay () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->pay([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderListDetailDto"
        );
    }

    /**
     * 财务修改支付方式
     *
     * @support  int $id 订单id [ require true ]
     * @support  string $pay_type 支付方式 [ require true ]
     * @support  string $payment_no 支付流水号 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changePayType () {
        return self::getClass()->changePayType([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\OfflineOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\OfflineOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}